/*
 * Decompiled with CFR 0.152.
 */
package io.jbock.simple.processor;

import io.jbock.simple.processor.ContextComponent;
import io.jbock.simple.processor.ProcessorComponent;
import io.jbock.simple.processor.binding.InjectBindingCache;
import io.jbock.simple.processor.binding.InjectBindingScanner;
import io.jbock.simple.processor.binding.KeyCache;
import io.jbock.simple.processor.step.BindingRegistry;
import io.jbock.simple.processor.step.ComponentFactoryStep;
import io.jbock.simple.processor.step.ComponentStep;
import io.jbock.simple.processor.step.InjectStep;
import io.jbock.simple.processor.step.ProvidesStep;
import io.jbock.simple.processor.util.ClearableCache;
import io.jbock.simple.processor.util.SafeElements;
import io.jbock.simple.processor.util.SafeTypes;
import io.jbock.simple.processor.util.SourceFileGenerator;
import io.jbock.simple.processor.util.SpecWriter;
import io.jbock.simple.processor.util.TypeTool;
import io.jbock.simple.processor.validation.ExecutableElementValidator;
import io.jbock.simple.processor.validation.InjectBindingValidator;
import io.jbock.simple.processor.validation.TypeElementValidator;
import java.util.List;
import javax.annotation.processing.Filer;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;

final class ProcessorComponent_Impl
implements ProcessorComponent {
    private final ProvidesStep providesStep;
    private final ComponentFactoryStep componentFactoryStep;
    private final InjectStep injectStep;
    private final ComponentStep componentStep;
    private final List<ClearableCache> caches;

    private ProcessorComponent_Impl(ProvidesStep providesStep, ComponentFactoryStep componentFactoryStep, InjectStep injectStep, ComponentStep componentStep, List<ClearableCache> caches) {
        this.providesStep = providesStep;
        this.componentFactoryStep = componentFactoryStep;
        this.injectStep = injectStep;
        this.componentStep = componentStep;
        this.caches = caches;
    }

    @Override
    public ComponentStep componentStep() {
        return this.componentStep;
    }

    @Override
    public InjectStep injectStep() {
        return this.injectStep;
    }

    @Override
    public ProvidesStep providesStep() {
        return this.providesStep;
    }

    @Override
    public ComponentFactoryStep componentFactoryStep() {
        return this.componentFactoryStep;
    }

    @Override
    public List<ClearableCache> clearableCaches() {
        return this.caches;
    }

    static ProcessorComponent.Factory factory() {
        return new Factory_Impl();
    }

    private static final class Factory_Impl
    implements ProcessorComponent.Factory {
        private Factory_Impl() {
        }

        @Override
        public ProcessorComponent create(ProcessingEnvironment processingEnvironment) {
            Filer filer = ProcessorComponent.provideFiler(processingEnvironment);
            Types types = ProcessorComponent.provideTypes(processingEnvironment);
            SafeTypes safeTypes = new SafeTypes(types);
            Elements elements = ProcessorComponent.provideElements(processingEnvironment);
            SafeElements safeElements = new SafeElements(elements);
            TypeTool typeTool = new TypeTool(safeElements, safeTypes);
            KeyCache keyCache = new KeyCache(typeTool);
            BindingRegistry bindingRegistry = new BindingRegistry(keyCache);
            InjectBindingScanner injectBindingScanner = new InjectBindingScanner(typeTool);
            InjectBindingValidator injectBindingValidator = new InjectBindingValidator(typeTool, injectBindingScanner);
            ContextComponent.Factory contextComponentFactory = new ContextComponent.Factory(typeTool);
            Messager messager = ProcessorComponent.provideMessager(processingEnvironment);
            ProvidesStep providesStep = new ProvidesStep(messager, bindingRegistry);
            SourceFileGenerator sourceFileGenerator = new SourceFileGenerator(filer, messager);
            SpecWriter specWriter = new SpecWriter(sourceFileGenerator, messager);
            TypeElementValidator typeElementValidator = new TypeElementValidator();
            ExecutableElementValidator executableElementValidator = new ExecutableElementValidator(typeTool, typeElementValidator);
            ComponentFactoryStep componentFactoryStep = new ComponentFactoryStep(messager, typeElementValidator, executableElementValidator);
            InjectStep injectStep = new InjectStep(injectBindingValidator, executableElementValidator, messager, bindingRegistry);
            ComponentStep componentStep = new ComponentStep(messager, typeTool, typeElementValidator, executableElementValidator, specWriter, contextComponentFactory);
            InjectBindingCache injectBindingCache = new InjectBindingCache();
            List<ClearableCache> caches = ProcessorComponent.caches(injectBindingCache, keyCache, safeElements);
            return new ProcessorComponent_Impl(providesStep, componentFactoryStep, injectStep, componentStep, caches);
        }
    }
}

