/*
 * Decompiled with CFR 0.152.
 */
package io.jbock.simple.processor.binding;

import io.jbock.simple.javapoet.ClassName;
import io.jbock.simple.processor.binding.KeyFactory;
import io.jbock.simple.processor.binding.ParameterBinding;
import io.jbock.simple.processor.util.Suppliers;
import io.jbock.simple.processor.util.ValidationFailure;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.ElementFilter;

public class BuilderElement {
    private final TypeElement element;
    private final ClassName parentClass;
    private final KeyFactory keyFactory;
    private final Supplier<ExecutableElement> buildMethod = Suppliers.memoize(() -> {
        Element componentElement = this.element().getEnclosingElement();
        List methods = ElementFilter.methodsIn(this.element().getEnclosedElements()).stream().filter(m -> !m.getModifiers().contains((Object)Modifier.STATIC)).filter(m -> this.qualifiers().tool().isSameType(m.getReturnType(), componentElement.asType())).collect(Collectors.toList());
        if (methods.isEmpty()) {
            throw new ValidationFailure("Build method not found", this.element());
        }
        if (methods.size() != 1) {
            throw new ValidationFailure("Only one build method allowed", this.element());
        }
        ExecutableElement result = (ExecutableElement)methods.get(0);
        if (!result.getParameters().isEmpty()) {
            throw new ValidationFailure("The build method may not have any parameters", result);
        }
        return result;
    });
    private final Supplier<List<ExecutableElement>> setterMethods = Suppliers.memoize(() -> {
        ExecutableElement buildMethod = this.buildMethod();
        List result = ElementFilter.methodsIn(this.element().getEnclosedElements()).stream().filter(m -> !m.getModifiers().contains((Object)Modifier.STATIC)).filter(m -> !Objects.equals(m, buildMethod)).collect(Collectors.toList());
        for (ExecutableElement m2 : result) {
            if (!this.qualifiers().tool().isSameType(m2.getReturnType(), this.element().asType())) {
                throw new ValidationFailure("The setter method must return the builder type", m2);
            }
            if (m2.getParameters().size() == 1) continue;
            throw new ValidationFailure("The setter method must have exactly one parameter", m2);
        }
        return result;
    });

    BuilderElement(TypeElement element, ClassName parentClass, KeyFactory keyFactory) {
        this.element = element;
        this.parentClass = parentClass;
        this.keyFactory = keyFactory;
    }

    public TypeElement element() {
        return this.element;
    }

    public ClassName generatedClass() {
        return this.parentClass.nestedClass(this.element().getSimpleName() + "_Impl");
    }

    public ExecutableElement buildMethod() {
        return this.buildMethod.get();
    }

    List<ParameterBinding> parameterBindings() {
        return this.setterMethods().stream().map(p -> ParameterBinding.create(p, this.qualifiers())).collect(Collectors.toList());
    }

    List<ExecutableElement> setterMethods() {
        return this.setterMethods.get();
    }

    private KeyFactory qualifiers() {
        return this.keyFactory;
    }
}

