/*
 * Decompiled with CFR 0.152.
 */
package io.jbock.simple.processor.binding;

import io.jbock.simple.Component;
import io.jbock.simple.Inject;
import io.jbock.simple.javapoet.ClassName;
import io.jbock.simple.processor.util.Suppliers;
import io.jbock.simple.processor.util.Visitors;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;

public final class ComponentElement {
    private final TypeElement element;
    private final Supplier<ClassName> generatedClass = Suppliers.memoize(() -> {
        ClassName className = ClassName.get(this.element());
        return className.topLevelClassName().peerClass(String.join((CharSequence)"_", className.simpleNames()) + "_Impl");
    });
    private final Supplier<List<TypeElement>> modules = Suppliers.memoize(() -> {
        List<? extends AnnotationMirror> annotationMirrors = this.element().getAnnotationMirrors();
        AnnotationMirror annotationMirror = annotationMirrors.stream().filter(mirror -> {
            TypeElement tel = Visitors.TYPE_ELEMENT_VISITOR.visit(mirror.getAnnotationType().asElement());
            if (tel == null) {
                return false;
            }
            return tel.getQualifiedName().contentEquals(Component.class.getCanonicalName());
        }).findFirst().orElseThrow(AssertionError::new);
        Map<? extends ExecutableElement, ? extends AnnotationValue> elementValues = annotationMirror.getElementValues();
        return elementValues.entrySet().stream().filter(e -> "modules".contentEquals(((ExecutableElement)e.getKey()).getSimpleName())).map(Map.Entry::getValue).flatMap(m -> Visitors.ANNOTATION_VALUE_AS_ARRAY.visit((AnnotationValue)m, (Void)null).stream()).map(Visitors.ANNOTATION_VALUE_AS_TYPE::visit).filter(Objects::nonNull).map(Visitors.DECLARED_TYPE_VISITOR::visit).filter(Objects::nonNull).map(DeclaredType::asElement).filter(Objects::nonNull).map(Visitors.TYPE_ELEMENT_VISITOR::visit).collect(Collectors.toList());
    });

    @Inject
    public ComponentElement(TypeElement element) {
        this.element = element;
    }

    public TypeElement element() {
        return this.element;
    }

    public ClassName generatedClass() {
        return this.generatedClass.get();
    }

    public boolean publicMockBuilder() {
        Component annotation = this.element.getAnnotation(Component.class);
        if (annotation == null) {
            return false;
        }
        return annotation.publicMockBuilder();
    }

    public boolean mockBuilder() {
        Component annotation = this.element.getAnnotation(Component.class);
        if (annotation == null) {
            return false;
        }
        return annotation.mockBuilder();
    }

    public List<TypeElement> modules() {
        return this.modules.get();
    }
}

