/*
 * Decompiled with CFR 0.152.
 */
package io.jbock.simple.processor.binding;

import io.jbock.simple.javapoet.ClassName;
import io.jbock.simple.processor.binding.KeyFactory;
import io.jbock.simple.processor.binding.ParameterBinding;
import io.jbock.simple.processor.util.Suppliers;
import io.jbock.simple.processor.util.ValidationFailure;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.util.ElementFilter;

public class FactoryElement {
    private final TypeElement element;
    private final ClassName parentClass;
    private final KeyFactory keyFactory;
    private final Supplier<ExecutableElement> singleAbstractMethod = Suppliers.memoize(() -> {
        List methods = ElementFilter.methodsIn(this.element().getEnclosedElements()).stream().filter(m -> !m.getModifiers().contains((Object)Modifier.STATIC)).collect(Collectors.toList());
        if (methods.isEmpty()) {
            throw new ValidationFailure("Factory method not found", this.element());
        }
        if (methods.size() != 1) {
            throw new ValidationFailure("Only one method allowed", this.element());
        }
        ExecutableElement method = (ExecutableElement)methods.get(0);
        if (method.getReturnType().getKind() == TypeKind.VOID) {
            throw new ValidationFailure("The method may not return void", method);
        }
        return method;
    });

    FactoryElement(TypeElement element, ClassName parentClass, KeyFactory keyFactory) {
        this.element = element;
        this.parentClass = parentClass;
        this.keyFactory = keyFactory;
    }

    public TypeElement element() {
        return this.element;
    }

    public ClassName generatedClass() {
        return this.parentClass.nestedClass(this.element().getSimpleName() + "_Impl");
    }

    public ExecutableElement singleAbstractMethod() {
        return this.singleAbstractMethod.get();
    }

    List<ParameterBinding> parameterBindings() {
        return this.singleAbstractMethod().getParameters().stream().map(p -> ParameterBinding.create(p, this.qualifiers())).collect(Collectors.toList());
    }

    private KeyFactory qualifiers() {
        return this.keyFactory;
    }
}

