/*
 * Decompiled with CFR 0.152.
 */
package io.jbock.simple.processor.binding;

import io.jbock.simple.javapoet.CodeBlock;
import io.jbock.simple.javapoet.ParameterSpec;
import io.jbock.simple.javapoet.ParameterizedTypeName;
import io.jbock.simple.javapoet.TypeName;
import io.jbock.simple.processor.binding.Binding;
import io.jbock.simple.processor.binding.DependencyRequest;
import io.jbock.simple.processor.binding.Key;
import io.jbock.simple.processor.binding.KeyFactory;
import io.jbock.simple.processor.binding.ParameterBinding;
import io.jbock.simple.processor.util.Suppliers;
import io.jbock.simple.processor.util.Visitors;
import io.jbock.simple.processor.writing.NamedBinding;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;

public final class InjectBinding
extends Binding {
    private final ExecutableElement bindingElement;
    private final KeyFactory keyFactory;
    private final Supplier<String> suggestedVariableName = Suppliers.memoize(() -> {
        Element enclosing = this.element().getEnclosingElement();
        if (enclosing == null) {
            return InjectBinding.lowerFirst(this.simpleName(this.key().typeName()));
        }
        if (!this.keyFactory().tool().isSameType(this.key().type(), enclosing.asType())) {
            return InjectBinding.lowerFirst(enclosing.getSimpleName().toString() + this.simpleName(this.key().typeName()));
        }
        TypeElement enclosingOuter = Visitors.TYPE_ELEMENT_VISITOR.visit(enclosing.getEnclosingElement());
        if (enclosingOuter != null && this.keyFactory().tool().isSameType(this.key().type(), enclosing.asType())) {
            return InjectBinding.lowerFirst(enclosingOuter.getSimpleName().toString() + this.simpleName(this.key().typeName()));
        }
        return InjectBinding.lowerFirst(this.simpleName(this.key().typeName()));
    });
    private final Supplier<List<DependencyRequest>> requests = Suppliers.memoize(() -> this.element().getParameters().stream().map(parameter -> new DependencyRequest(this.keyFactory().getKey((VariableElement)parameter), (Element)parameter, this.element())).collect(Collectors.toList()));

    private String simpleName(TypeName typeName) {
        if (typeName instanceof ParameterizedTypeName) {
            return InjectBinding.simpleTypeName((ParameterizedTypeName)typeName);
        }
        return InjectBinding.verySimpleTypeName(typeName.toString());
    }

    static String simpleTypeName(ParameterizedTypeName type) {
        StringBuilder sb = new StringBuilder();
        sb.append(type.rawType.simpleName());
        for (TypeName typeName : type.typeArguments) {
            if (typeName instanceof ParameterizedTypeName) {
                sb.append(InjectBinding.simpleTypeName((ParameterizedTypeName)typeName));
                continue;
            }
            sb.append(InjectBinding.verySimpleTypeName(typeName.toString()));
        }
        return sb.toString();
    }

    static String verySimpleTypeName(String typeName) {
        int i = ((String)typeName).indexOf(60);
        if (i >= 0) {
            typeName = ((String)typeName).substring(0, i);
        }
        if ((i = ((String)typeName).lastIndexOf(46)) >= 0) {
            typeName = ((String)typeName).substring(i + 1);
        }
        if (Character.isLowerCase(((String)typeName).charAt(0))) {
            typeName = Character.toUpperCase(((String)typeName).charAt(0)) + ((String)typeName).substring(1);
        }
        return typeName;
    }

    private static String lowerFirst(String s) {
        return Character.toLowerCase(s.charAt(0)) + s.substring(1);
    }

    InjectBinding(Key key, KeyFactory keyFactory, ExecutableElement bindingElement) {
        super(key);
        this.bindingElement = bindingElement;
        this.keyFactory = keyFactory;
    }

    @Override
    public String suggestedVariableName() {
        return this.suggestedVariableName.get();
    }

    @Override
    public ExecutableElement element() {
        return this.bindingElement;
    }

    @Override
    public List<DependencyRequest> requests() {
        return this.requests.get();
    }

    @Override
    public CodeBlock invocation(Function<Key, ParameterSpec> names, Map<Key, NamedBinding> bindings, boolean paramsAreFields) {
        CodeBlock params = this.requests().stream().map(d -> {
            NamedBinding namedBinding = (NamedBinding)bindings.get(d.key());
            ParameterSpec param = (ParameterSpec)names.apply(d.key());
            boolean isParameter = namedBinding != null && namedBinding.binding() instanceof ParameterBinding;
            return isParameter && paramsAreFields ? CodeBlock.of("this.$N", param) : CodeBlock.of("$N", param);
        }).collect(CodeBlock.joining(", "));
        if (this.bindingElement.getKind() == ElementKind.CONSTRUCTOR) {
            return CodeBlock.of("new $T($L)", this.bindingElement.getEnclosingElement().asType(), params);
        }
        return CodeBlock.of("$T.$L($L)", this.bindingElement.getEnclosingElement().asType(), this.bindingElement.getSimpleName().toString(), params);
    }

    public String toString() {
        return "InjectBinding[" + this.key() + "]";
    }

    private KeyFactory keyFactory() {
        return this.keyFactory;
    }
}

