/*
 * Decompiled with CFR 0.152.
 */
package io.jbock.simple.processor.binding;

import io.jbock.simple.Inject;
import io.jbock.simple.processor.binding.Binding;
import io.jbock.simple.processor.binding.InjectBinding;
import io.jbock.simple.processor.binding.InjectBindingCache;
import io.jbock.simple.processor.binding.InjectBindingScanner;
import io.jbock.simple.processor.binding.Key;
import io.jbock.simple.processor.binding.KeyFactory;
import io.jbock.simple.processor.util.TypeTool;
import io.jbock.simple.processor.util.Visitors;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;

public final class InjectBindingFactory {
    private final InjectBindingCache injectBindingCache;
    private final TypeTool tool;
    private final KeyFactory keyFactory;
    private final InjectBindingScanner injectBindingScanner;

    @Inject
    public InjectBindingFactory(TypeTool tool, InjectBindingCache injectBindingCache, KeyFactory keyFactory, InjectBindingScanner injectBindingScanner) {
        this.tool = tool;
        this.injectBindingCache = injectBindingCache;
        this.keyFactory = keyFactory;
        this.injectBindingScanner = injectBindingScanner;
    }

    public Map<Key, InjectBinding> injectBindings(TypeElement typeElement) {
        return this.injectBindingCache.computeIfAbsent(typeElement, this::injectBindingsMiss);
    }

    private Map<Key, InjectBinding> injectBindingsMiss(TypeElement typeElement) {
        LinkedHashMap<Key, InjectBinding> result = new LinkedHashMap<Key, InjectBinding>();
        List<ExecutableElement> methods = this.injectBindingScanner.scan(typeElement);
        for (ExecutableElement method : methods) {
            InjectBinding b = this.keyFactory.createBinding(method);
            result.put(b.key(), b);
        }
        return result;
    }

    public Optional<Binding> binding(Key key) {
        return this.tool.types().asElement(key.type()).map(Visitors.TYPE_ELEMENT_VISITOR::visit).flatMap(typeElement -> {
            Map<Key, InjectBinding> m = this.injectBindings((TypeElement)typeElement);
            return Optional.ofNullable(m.get(key));
        });
    }
}

