/*
 * Decompiled with CFR 0.152.
 */
package io.jbock.simple.processor.binding;

import io.jbock.simple.Inject;
import io.jbock.simple.processor.binding.Key;
import io.jbock.simple.processor.util.ClearableCache;
import io.jbock.simple.processor.util.SimpleAnnotation;
import io.jbock.simple.processor.util.TypeTool;
import io.jbock.simple.processor.util.ValidationFailure;
import io.jbock.simple.processor.util.Visitors;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;

public class KeyCache
implements ClearableCache {
    private final Map<Element, Key> keyCache = new HashMap<Element, Key>();
    private final TypeTool tool;

    @Inject
    public KeyCache(TypeTool tool) {
        this.tool = tool;
    }

    public Key getKey(ExecutableElement element) {
        Key key = this.keyCache.get(element);
        if (key != null) {
            return key;
        }
        TypeMirror returnType = element.getKind() == ElementKind.CONSTRUCTOR ? element.getEnclosingElement().asType() : element.getReturnType();
        key = Key.create(returnType, this.getQualifier(element));
        this.keyCache.put(element, key);
        return key;
    }

    Key getKey(VariableElement parameter) {
        Key key = this.keyCache.get(parameter);
        if (key != null) {
            return key;
        }
        key = Key.create(parameter.asType(), this.getQualifier(parameter));
        this.keyCache.put(parameter, key);
        return key;
    }

    private Optional<SimpleAnnotation> getQualifier(Element element) {
        List qualifiers = element.getAnnotationMirrors().stream().filter(this::hasQualifierAnnotation).map(mirror -> SimpleAnnotation.create(mirror, this.tool.elements(), this.tool.types())).collect(Collectors.toList());
        if (qualifiers.isEmpty()) {
            return Optional.empty();
        }
        if (qualifiers.size() == 1) {
            return Optional.of((SimpleAnnotation)qualifiers.get(0));
        }
        throw new ValidationFailure("Found more than one qualifier annotation", element);
    }

    private boolean hasQualifierAnnotation(AnnotationMirror mirror) {
        DeclaredType type = mirror.getAnnotationType();
        TypeElement element = Visitors.TYPE_ELEMENT_VISITOR.visit(type.asElement());
        return this.tool.hasQualifierAnnotation(element);
    }

    @Override
    public void clearCache() {
        this.keyCache.clear();
    }
}

