/*
 * Decompiled with CFR 0.152.
 */
package io.jbock.simple.processor.binding;

import io.jbock.simple.Component;
import io.jbock.simple.Inject;
import io.jbock.simple.Provides;
import io.jbock.simple.processor.binding.Binding;
import io.jbock.simple.processor.binding.BuilderElement;
import io.jbock.simple.processor.binding.ComponentElement;
import io.jbock.simple.processor.binding.DependencyRequest;
import io.jbock.simple.processor.binding.FactoryElement;
import io.jbock.simple.processor.binding.InjectBinding;
import io.jbock.simple.processor.binding.Key;
import io.jbock.simple.processor.binding.KeyCache;
import io.jbock.simple.processor.binding.ParameterBinding;
import io.jbock.simple.processor.util.Suppliers;
import io.jbock.simple.processor.util.TypeTool;
import io.jbock.simple.processor.util.ValidationFailure;
import io.jbock.simple.processor.util.Visitors;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.util.ElementFilter;

public class KeyFactory {
    private final TypeTool tool;
    private final ComponentElement componentElement;
    private final KeyCache keyCache;
    private final Supplier<Optional<FactoryElement>> factoryElement = Suppliers.memoize(() -> {
        for (Element element : this.componentElement().element().getEnclosedElements()) {
            TypeElement tel;
            boolean hasFactoryAnnotation = element.getAnnotation(Component.Factory.class) != null;
            if (!hasFactoryAnnotation || (tel = Visitors.TYPE_ELEMENT_VISITOR.visit(element)) == null) continue;
            return Optional.of(new FactoryElement(tel, this.componentElement().generatedClass(), this));
        }
        return Optional.empty();
    });
    private final Supplier<Map<Key, ParameterBinding>> parameterBindings = Suppliers.memoize(() -> {
        List pBindings = this.factoryElement().map(FactoryElement::parameterBindings).or(() -> this.builderElement().map(BuilderElement::parameterBindings)).orElse(List.of());
        LinkedHashMap<Key, ParameterBinding> result = new LinkedHashMap<Key, ParameterBinding>();
        for (ParameterBinding b : pBindings) {
            ParameterBinding previousBinding = result.put(b.key(), b);
            if (previousBinding == null) continue;
            Element p = previousBinding.element();
            throw new ValidationFailure("The binding is in conflict with another parameter: " + p.asType() + " " + p.getSimpleName(), b.element());
        }
        return result;
    });
    private final Supplier<Optional<BuilderElement>> builderElement = Suppliers.memoize(() -> {
        for (Element element : this.componentElement().element().getEnclosedElements()) {
            TypeElement tel;
            boolean hasBuilderAnnotation = element.getAnnotation(Component.Builder.class) != null;
            if (!hasBuilderAnnotation || (tel = Visitors.TYPE_ELEMENT_VISITOR.visit(element)) == null) continue;
            return Optional.of(new BuilderElement(tel, this.componentElement().generatedClass(), this));
        }
        return Optional.empty();
    });
    private final Supplier<Map<Key, InjectBinding>> providesBindings = Suppliers.memoize(() -> {
        ArrayList<ExecutableElement> methods = new ArrayList<ExecutableElement>();
        methods.addAll(ElementFilter.methodsIn(this.componentElement().element().getEnclosedElements()));
        for (TypeElement module : this.componentElement().modules()) {
            methods.addAll(ElementFilter.methodsIn(module.getEnclosedElements()));
        }
        LinkedHashMap<Key, InjectBinding> result = new LinkedHashMap<Key, InjectBinding>();
        for (ExecutableElement method : methods) {
            if (!this.hasProvidesOrInjectAnnotation(method)) continue;
            Key key = this.keyCache().getKey(method);
            InjectBinding b = this.createBinding(method);
            result.put(key, b);
        }
        return result;
    });
    private final Supplier<Map<Key, DependencyRequest>> requests = Suppliers.memoize(() -> {
        List<ExecutableElement> methods = ElementFilter.methodsIn(this.componentElement().element().getEnclosedElements());
        LinkedHashMap<Key, DependencyRequest> result = new LinkedHashMap<Key, DependencyRequest>();
        for (ExecutableElement method : methods) {
            if (method.getModifiers().contains((Object)Modifier.STATIC) || this.hasProvidesOrInjectAnnotation(method)) continue;
            if (!method.getParameters().isEmpty()) {
                throw new ValidationFailure("Request method may not have any parameters", method);
            }
            if (method.getModifiers().contains((Object)Modifier.DEFAULT)) {
                throw new ValidationFailure("Default modifier is not allowed here", method);
            }
            if (method.getReturnType().getKind() == TypeKind.VOID) {
                throw new ValidationFailure("Request method may not return void", method);
            }
            Key key = this.keyCache().getKey(method);
            result.put(key, new DependencyRequest(key, method, method));
        }
        return result;
    });

    @Inject
    public KeyFactory(TypeTool tool, ComponentElement componentElement, KeyCache keyCache) {
        this.tool = tool;
        this.componentElement = componentElement;
        this.keyCache = keyCache;
    }

    Key getKey(VariableElement parameter) {
        return this.keyCache.getKey(parameter);
    }

    InjectBinding createBinding(ExecutableElement m) {
        Key key = this.keyCache.getKey(m);
        if (m.getKind() == ElementKind.CONSTRUCTOR && key.qualifier().isPresent()) {
            throw new ValidationFailure("Constructors can't have qualifiers", m);
        }
        return new InjectBinding(key, this, m);
    }

    TypeTool tool() {
        return this.tool;
    }

    public Optional<FactoryElement> factoryElement() {
        return this.factoryElement.get();
    }

    public Optional<Binding> parameterBinding(Key key) {
        return Optional.ofNullable((Binding)this.parameterBindings.get().get(key));
    }

    public Collection<ParameterBinding> parameterBindings() {
        return this.parameterBindings.get().values();
    }

    private boolean hasProvidesOrInjectAnnotation(ExecutableElement method) {
        return method.getAnnotation(Provides.class) != null || this.tool().hasInjectAnnotation(method);
    }

    public Optional<BuilderElement> builderElement() {
        return this.builderElement.get();
    }

    public boolean isComponentRequest(Binding binding) {
        return this.requests.get().containsKey(binding.key());
    }

    public Collection<DependencyRequest> requests() {
        return this.requests.get().values();
    }

    public Map<Key, InjectBinding> providesBindings() {
        return this.providesBindings.get();
    }

    private ComponentElement componentElement() {
        return this.componentElement;
    }

    private KeyCache keyCache() {
        return this.keyCache;
    }
}

