/*
 * Decompiled with CFR 0.152.
 */
package io.jbock.simple.processor.binding;

import io.jbock.simple.javapoet.CodeBlock;
import io.jbock.simple.javapoet.ParameterSpec;
import io.jbock.simple.processor.binding.Binding;
import io.jbock.simple.processor.binding.DependencyRequest;
import io.jbock.simple.processor.binding.Key;
import io.jbock.simple.processor.binding.KeyFactory;
import io.jbock.simple.processor.writing.NamedBinding;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.VariableElement;

public final class ParameterBinding
extends Binding {
    private final Element element;
    private final String suggestedVariableName;

    private ParameterBinding(Key key, Element element, String suggestedVariableName) {
        super(key);
        this.element = element;
        this.suggestedVariableName = suggestedVariableName;
    }

    public static ParameterBinding create(VariableElement parameter, KeyFactory keyFactory) {
        Key key = keyFactory.getKey(parameter);
        return new ParameterBinding(key, parameter, parameter.getSimpleName().toString());
    }

    public static ParameterBinding create(ExecutableElement setter, KeyFactory keyFactory) {
        VariableElement parameter = setter.getParameters().get(0);
        Key key = keyFactory.getKey(parameter);
        return new ParameterBinding(key, setter, parameter.getSimpleName().toString());
    }

    @Override
    public CodeBlock invocation(Function<Key, ParameterSpec> names, Map<Key, NamedBinding> bindings, boolean paramsAreFields) {
        ParameterSpec param = names.apply(this.key());
        return paramsAreFields ? CodeBlock.of("this.$N", param) : CodeBlock.of("$N", param);
    }

    public String toString() {
        return "ParameterBinding[" + this.key() + "]";
    }

    @Override
    public Element element() {
        return this.element;
    }

    @Override
    public List<DependencyRequest> requests() {
        return List.of();
    }

    @Override
    public String suggestedVariableName() {
        return this.suggestedVariableName;
    }
}

