/*
 * Decompiled with CFR 0.152.
 */
package io.jbock.simple.processor.binding;

import io.jbock.simple.javapoet.CodeBlock;
import io.jbock.simple.javapoet.ParameterSpec;
import io.jbock.simple.processor.binding.Binding;
import io.jbock.simple.processor.binding.DependencyRequest;
import io.jbock.simple.processor.binding.Key;
import io.jbock.simple.processor.util.ProviderType;
import io.jbock.simple.processor.writing.NamedBinding;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.lang.model.element.Element;

public class ProviderBinding
extends Binding {
    private final Binding sourceBinding;
    private final ProviderType providerType;

    public ProviderBinding(Key key, Binding sourceBinding, ProviderType providerType) {
        super(key);
        this.sourceBinding = sourceBinding;
        this.providerType = providerType;
    }

    @Override
    public Element element() {
        return this.sourceBinding.element();
    }

    @Override
    public List<DependencyRequest> requests() {
        return this.sourceBinding.requests();
    }

    @Override
    public CodeBlock invocation(Function<Key, ParameterSpec> names, Map<Key, NamedBinding> bindings, boolean paramsAreFields) {
        return CodeBlock.of("() -> $L", this.sourceBinding.invocation(names, bindings, paramsAreFields));
    }

    public Binding sourceBinding() {
        return this.sourceBinding;
    }

    @Override
    public String suggestedVariableName() {
        return this.sourceBinding.suggestedVariableName() + "Provider";
    }

    public String toString() {
        return this.providerType.kind().className() + "<" + this.sourceBinding.key() + ">";
    }
}

