/*
 * Decompiled with CFR 0.152.
 */
package io.jbock.simple.processor.graph;

import io.jbock.simple.javapoet.TypeName;
import io.jbock.simple.processor.binding.ComponentElement;
import io.jbock.simple.processor.util.ValidationFailure;
import io.jbock.simple.processor.util.Visitors;
import java.util.Locale;
import javax.lang.model.element.Element;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.NestingKind;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;

class AccessibilityValidator {
    private final PackageElement componentPackage;
    private final ComponentElement component;

    private AccessibilityValidator(PackageElement componentPackage, ComponentElement component) {
        this.componentPackage = componentPackage;
        this.component = component;
    }

    static AccessibilityValidator create(ComponentElement component) {
        return new AccessibilityValidator(AccessibilityValidator.getPackage(component.element()), component);
    }

    void checkAccessible(Element e) {
        if (AccessibilityValidator.getPackage(e).equals(this.componentPackage)) {
            return;
        }
        if (!e.getModifiers().contains((Object)Modifier.PUBLIC)) {
            throw new ValidationFailure(e.getKind().name().toLowerCase(Locale.ROOT) + " is not accessible from " + this.component.element().getQualifiedName(), e);
        }
        TypeElement nonPublic = AccessibilityValidator.findNonPublicEnclosing(e.getEnclosingElement());
        if (nonPublic == null) {
            return;
        }
        throw new ValidationFailure(TypeName.get(nonPublic.asType()) + " is not accessible from " + this.component.element().getQualifiedName(), e);
    }

    private static PackageElement getPackage(Element element) {
        for (Element current = element; current != null; current = current.getEnclosingElement()) {
            if (current.getModifiers().contains((Object)Modifier.PRIVATE)) {
                throw new ValidationFailure("Enclosing type may not be private", current);
            }
            AccessibilityValidator.checkNesting(Visitors.TYPE_ELEMENT_VISITOR.visit(current));
            PackageElement e = Visitors.PACKAGE_VISITOR.visit(current);
            if (e == null) continue;
            return e;
        }
        throw new AssertionError((Object)"we should never get here");
    }

    private static TypeElement findNonPublicEnclosing(Element element) {
        for (Element current = element; current != null; current = current.getEnclosingElement()) {
            TypeElement t = Visitors.TYPE_ELEMENT_VISITOR.visit(current);
            if (t == null) {
                return null;
            }
            if (t.getModifiers().contains((Object)Modifier.PUBLIC)) continue;
            return t;
        }
        return null;
    }

    private static void checkNesting(TypeElement t) {
        if (t == null) {
            return;
        }
        if (t.getNestingKind() == NestingKind.MEMBER && !t.getModifiers().contains((Object)Modifier.STATIC)) {
            throw new ValidationFailure("Non-static inner class is not allowed here", t);
        }
    }
}

