/*
 * Decompiled with CFR 0.152.
 */
package io.jbock.simple.processor.graph;

import io.jbock.simple.processor.binding.Binding;
import io.jbock.simple.processor.binding.ProviderBinding;
import io.jbock.simple.processor.graph.Edge;
import io.jbock.simple.processor.graph.Graph;
import io.jbock.simple.processor.util.Printing;
import io.jbock.simple.processor.util.ValidationFailure;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;

final class CyclePrinter {
    private final Graph graph;

    CyclePrinter(Graph graph) {
        this.graph = graph;
    }

    ValidationFailure fail() {
        Report report = this.cycleMessage();
        return new ValidationFailure(report.message, report.binding.element());
    }

    Report cycleMessage() {
        for (Binding binding : this.graph.nodes()) {
            Optional<List<Edge>> cycle = this.findProperCycle(binding);
            if (!cycle.isPresent()) continue;
            return new Report(this.cycleMessage(cycle.orElseThrow()), binding);
        }
        throw new AssertionError((Object)"input didn't contain a cycle");
    }

    private String cycleMessage(List<Edge> cycle) {
        ArrayList<Object> message = new ArrayList<Object>();
        message.add("Found a dependency cycle:");
        for (Edge edge : cycle) {
            Binding destination = edge.destination();
            if (destination instanceof ProviderBinding) {
                ProviderBinding b = (ProviderBinding)destination;
                message.add("    " + edge.source().key().typeName() + " is injected at");
                message.add("        " + Printing.bindingElementToString(b.sourceBinding().element()));
                continue;
            }
            message.add("    " + edge.source().key().typeName() + " is injected at");
            message.add("        " + Printing.bindingElementToString(destination.element()));
        }
        return String.join((CharSequence)"\n", message);
    }

    private Optional<List<Edge>> findProperCycle(Binding node) {
        LinkedHashSet<Binding> seen = new LinkedHashSet<Binding>();
        seen.add(node);
        List<Edge> cycle = this.findCycle(node, List.of(), seen);
        if (cycle.isEmpty()) {
            return Optional.empty();
        }
        if (!cycle.get(cycle.size() - 1).destination().equals(node)) {
            return Optional.empty();
        }
        return Optional.of(cycle);
    }

    private List<Edge> findCycle(Binding node, List<Edge> current, Set<Binding> seen) {
        List<Edge> edgesFrom = this.graph.edgesFrom(node);
        for (Edge edge : edgesFrom) {
            List<Edge> appended = this.append(current, edge);
            if (!seen.add(edge.destination())) {
                return appended;
            }
            List<Edge> cycle = this.findCycle(edge.destination(), appended, seen);
            if (cycle.isEmpty()) continue;
            return cycle;
        }
        return List.of();
    }

    private List<Edge> append(List<Edge> current, Edge next) {
        ArrayList<Edge> result = new ArrayList<Edge>(current.size() + 1);
        result.addAll(current);
        result.add(next);
        return result;
    }

    private static final class Report {
        final String message;
        final Binding binding;

        Report(String message, Binding binding) {
            this.message = message;
            this.binding = binding;
        }
    }
}

