/*
 * Decompiled with CFR 0.152.
 */
package io.jbock.simple.processor.graph;

import io.jbock.simple.processor.binding.Binding;
import io.jbock.simple.processor.graph.Edge;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

final class Graph {
    private final Set<Edge> edges;
    private final Set<Binding> nodes;

    Graph(Set<Edge> edges, Set<Binding> nodes) {
        this.edges = edges;
        this.nodes = nodes;
    }

    void addAll(Graph other) {
        this.edges.addAll(other.edges);
        this.nodes.addAll(other.nodes);
    }

    static Graph newGraph() {
        return new Graph(new LinkedHashSet<Edge>(), new LinkedHashSet<Binding>());
    }

    List<Edge> edgesFrom(Binding n) {
        return this.edges.stream().filter(edge -> edge.source().equals(n)).collect(Collectors.toList());
    }

    List<Edge> edgesTo(Binding m) {
        return this.edges.stream().filter(edge -> edge.destination().equals(m)).collect(Collectors.toList());
    }

    List<Binding> startNodes() {
        return this.nodes.stream().filter(r -> this.edgesTo((Binding)r).isEmpty()).collect(Collectors.toList());
    }

    void removeEdge(Edge edge) {
        this.edges.remove(edge);
    }

    Set<Binding> nodes() {
        return this.nodes;
    }

    Set<Edge> edges() {
        return this.edges;
    }
}

