/*
 * Decompiled with CFR 0.152.
 */
package io.jbock.simple.processor.graph;

import io.jbock.simple.Inject;
import io.jbock.simple.processor.binding.Binding;
import io.jbock.simple.processor.binding.DependencyRequest;
import io.jbock.simple.processor.binding.InjectBindingFactory;
import io.jbock.simple.processor.binding.Key;
import io.jbock.simple.processor.binding.KeyFactory;
import io.jbock.simple.processor.binding.ProviderBinding;
import io.jbock.simple.processor.graph.Edge;
import io.jbock.simple.processor.graph.Graph;
import io.jbock.simple.processor.graph.MissingBindingPrinter;
import io.jbock.simple.processor.util.ProviderType;
import io.jbock.simple.processor.util.TypeTool;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public class GraphFactory {
    private final TypeTool tool;
    private final KeyFactory keyFactory;
    private final InjectBindingFactory injectBindingFactory;
    private final Map<Key, Optional<Binding>> bindingCache = new HashMap<Key, Optional<Binding>>();
    private final MissingBindingPrinter missingBindingPrinter;

    @Inject
    public GraphFactory(TypeTool tool, KeyFactory keyFactory, InjectBindingFactory injectBindingFactory, MissingBindingPrinter missingBindingPrinter) {
        this.tool = tool;
        this.keyFactory = keyFactory;
        this.injectBindingFactory = injectBindingFactory;
        this.missingBindingPrinter = missingBindingPrinter;
    }

    private Optional<Binding> getBinding(DependencyRequest request) {
        return this.bindingCache.computeIfAbsent(request.key(), key -> this.keyFactory.parameterBinding((Key)key).or(() -> Optional.ofNullable(this.keyFactory.providesBindings().get(key))).or(() -> this.injectBindingFactory.binding((Key)key)).or(() -> this.providerBinding((Key)key)));
    }

    private Optional<Binding> providerBinding(Key key) {
        Optional<ProviderType> providerType = this.tool.getProviderType(key.type());
        if (providerType.isEmpty()) {
            return Optional.empty();
        }
        ProviderType provider = providerType.orElseThrow();
        Key innerKey = key.changeType(provider.innerType());
        return this.keyFactory.parameterBinding(innerKey).or(() -> Optional.ofNullable(this.keyFactory.providesBindings().get(innerKey))).or(() -> this.injectBindingFactory.binding(innerKey)).map(b -> new ProviderBinding(key, (Binding)b, provider));
    }

    Graph getGraph(DependencyRequest request) {
        List<DependencyRequest> dependencyTrace = List.of(request);
        Binding startNode = this.getBinding(request).orElseThrow(() -> this.missingBindingPrinter.fail(dependencyTrace));
        LinkedHashSet<Edge> edges = new LinkedHashSet<Edge>();
        LinkedHashSet<Binding> nodes = new LinkedHashSet<Binding>();
        nodes.add(startNode);
        this.addDependencies(dependencyTrace, nodes, edges, startNode);
        return new Graph(edges, nodes);
    }

    private void addDependencies(List<DependencyRequest> trace, Set<Binding> nodes, Set<Edge> edges, Binding node) {
        for (DependencyRequest request : node.requests()) {
            ArrayList<DependencyRequest> dependencyTrace = new ArrayList<DependencyRequest>(trace.size() + 1);
            dependencyTrace.addAll(trace);
            dependencyTrace.add(request);
            Binding dependency = this.getBinding(request).orElseThrow(() -> this.missingBindingPrinter.fail(dependencyTrace));
            Edge edge = new Edge(dependency, node);
            edges.add(edge);
            if (!nodes.add(dependency)) continue;
            this.addDependencies(dependencyTrace, nodes, edges, dependency);
        }
    }
}

