/*
 * Decompiled with CFR 0.152.
 */
package io.jbock.simple.processor.graph;

import io.jbock.simple.Inject;
import io.jbock.simple.processor.binding.ComponentElement;
import io.jbock.simple.processor.binding.DependencyRequest;
import io.jbock.simple.processor.util.Printing;
import io.jbock.simple.processor.util.ValidationFailure;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class MissingBindingPrinter {
    private final ComponentElement component;

    @Inject
    public MissingBindingPrinter(ComponentElement component) {
        this.component = component;
    }

    ValidationFailure fail(List<DependencyRequest> dependencyTrace) {
        ArrayList<DependencyRequest> trace = new ArrayList<DependencyRequest>(dependencyTrace);
        Collections.reverse(trace);
        return this.failInternal(trace);
    }

    private ValidationFailure failInternal(List<DependencyRequest> trace) {
        DependencyRequest request = trace.get(0);
        StringBuilder message = new StringBuilder();
        message.append("No binding found for " + request.key().toString() + ".");
        for (int i = 0; i < trace.size(); ++i) {
            DependencyRequest r = trace.get(i);
            String formatted = this.format(r, i == trace.size() - 1 ? "requested" : "injected");
            message.append("\n").append(formatted);
        }
        return new ValidationFailure(message.toString(), this.component.element());
    }

    private String format(DependencyRequest request, String verb) {
        return "    " + request.key() + " is " + verb + " at\n        " + Printing.bindingElementToString(request.requestElement());
    }
}

