/*
 * Decompiled with CFR 0.152.
 */
package io.jbock.simple.processor.graph;

import io.jbock.simple.Inject;
import io.jbock.simple.processor.binding.Binding;
import io.jbock.simple.processor.binding.ComponentElement;
import io.jbock.simple.processor.binding.DependencyRequest;
import io.jbock.simple.processor.binding.KeyFactory;
import io.jbock.simple.processor.binding.ParameterBinding;
import io.jbock.simple.processor.graph.AccessibilityValidator;
import io.jbock.simple.processor.graph.CyclePrinter;
import io.jbock.simple.processor.graph.Edge;
import io.jbock.simple.processor.graph.Graph;
import io.jbock.simple.processor.graph.GraphFactory;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;

public final class TopologicalSorter {
    private final GraphFactory graphFactory;
    private final ComponentElement component;
    private final KeyFactory keyFactory;

    @Inject
    public TopologicalSorter(GraphFactory graphFactory, ComponentElement component, KeyFactory keyFactory) {
        this.graphFactory = graphFactory;
        this.component = component;
        this.keyFactory = keyFactory;
    }

    public List<Binding> sortedBindings() {
        AccessibilityValidator validator = AccessibilityValidator.create(this.component);
        Graph graph = Graph.newGraph();
        for (ParameterBinding parameterBinding : this.keyFactory.parameterBindings()) {
            graph.nodes().add(parameterBinding);
        }
        for (DependencyRequest dependencyRequest : this.keyFactory.requests()) {
            graph.addAll(this.graphFactory.getGraph(dependencyRequest));
        }
        for (Binding binding : graph.nodes()) {
            if (binding instanceof ParameterBinding) continue;
            validator.checkAccessible(binding.element());
        }
        return this.sort(graph);
    }

    List<Binding> sort(Graph graph) {
        ArrayList<Binding> result = new ArrayList<Binding>(graph.nodes().size());
        ArrayDeque<Binding> s = new ArrayDeque<Binding>(graph.startNodes());
        while (!s.isEmpty()) {
            Binding n = (Binding)s.pop();
            result.add(n);
            for (Edge e : graph.edgesFrom(n)) {
                graph.removeEdge(e);
                Binding m = e.destination();
                if (!graph.edgesTo(m).isEmpty()) continue;
                s.push(m);
            }
        }
        if (!graph.edges().isEmpty()) {
            throw new CyclePrinter(graph).fail();
        }
        return result;
    }
}

