/*
 * Decompiled with CFR 0.152.
 */
package io.jbock.simple.processor.step;

import io.jbock.simple.Component;
import io.jbock.simple.Inject;
import io.jbock.simple.Modulus;
import io.jbock.simple.auto.common.BasicAnnotationProcessor;
import io.jbock.simple.javapoet.TypeSpec;
import io.jbock.simple.processor.ContextComponent;
import io.jbock.simple.processor.binding.KeyFactory;
import io.jbock.simple.processor.util.SpecWriter;
import io.jbock.simple.processor.util.TypeTool;
import io.jbock.simple.processor.util.ValidationFailure;
import io.jbock.simple.processor.validation.ExecutableElementValidator;
import io.jbock.simple.processor.validation.TypeElementValidator;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.processing.Messager;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.ElementFilter;

public class ComponentStep
implements BasicAnnotationProcessor.Step {
    private final Messager messager;
    private final TypeTool tool;
    private final TypeElementValidator typeElementValidator;
    private final ExecutableElementValidator executableElementValidator;
    private final SpecWriter specWriter;
    private final ContextComponent.Factory contextComponentFactory;

    @Inject
    public ComponentStep(Messager messager, TypeTool tool, TypeElementValidator typeElementValidator, ExecutableElementValidator executableElementValidator, SpecWriter specWriter, ContextComponent.Factory contextComponentFactory) {
        this.messager = messager;
        this.tool = tool;
        this.typeElementValidator = typeElementValidator;
        this.executableElementValidator = executableElementValidator;
        this.specWriter = specWriter;
        this.contextComponentFactory = contextComponentFactory;
    }

    @Override
    public Set<String> annotations() {
        return Set.of(Component.class.getCanonicalName());
    }

    @Override
    public Set<? extends Element> process(Map<String, Set<Element>> elementsByAnnotation) {
        List elements = elementsByAnnotation.values().stream().flatMap(Collection::stream).collect(Collectors.toList());
        List<TypeElement> typeElements = ElementFilter.typesIn(elements);
        for (TypeElement typeElement : typeElements) {
            try {
                this.process(typeElement);
            }
            catch (ValidationFailure f) {
                f.writeTo(this.messager);
            }
        }
        return Set.of();
    }

    private void process(TypeElement typeElement) {
        this.typeElementValidator.validate(typeElement);
        ContextComponent context = this.contextComponentFactory.create(typeElement);
        KeyFactory keyFactory = context.keyFactory();
        for (TypeElement module : context.componentElement().modules()) {
            if (module.getAnnotation(Modulus.class) != null) continue;
            throw new ValidationFailure("The module must be annotated with @Modulus", typeElement);
        }
        keyFactory.factoryElement().ifPresent(factory -> {
            ExecutableElement method = factory.singleAbstractMethod();
            if (!this.tool.types().isSameType(method.getReturnType(), typeElement.asType())) {
                throw new ValidationFailure("Factory method must return the component type", method);
            }
        });
        for (ExecutableElement m : ElementFilter.methodsIn(typeElement.getEnclosedElements())) {
            if (!m.getModifiers().contains((Object)Modifier.ABSTRACT)) continue;
            this.executableElementValidator.validate(m);
        }
        TypeSpec typeSpec = context.componentImpl().generate();
        this.specWriter.write(context.componentElement().generatedClass(), typeSpec);
    }
}

