/*
 * Decompiled with CFR 0.152.
 */
package io.jbock.simple.processor.step;

import io.jbock.simple.Inject;
import io.jbock.simple.auto.common.BasicAnnotationProcessor;
import io.jbock.simple.processor.step.BindingRegistry;
import io.jbock.simple.processor.util.ValidationFailure;
import io.jbock.simple.processor.validation.ExecutableElementValidator;
import io.jbock.simple.processor.validation.InjectBindingValidator;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.processing.Messager;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.util.ElementFilter;

public class InjectStep
implements BasicAnnotationProcessor.Step {
    private final InjectBindingValidator validator;
    private final ExecutableElementValidator executableElementValidator;
    private final Messager messager;
    private final BindingRegistry bindingRegistry;

    @Inject
    public InjectStep(InjectBindingValidator validator, ExecutableElementValidator executableElementValidator, Messager messager, BindingRegistry bindingRegistry) {
        this.validator = validator;
        this.executableElementValidator = executableElementValidator;
        this.messager = messager;
        this.bindingRegistry = bindingRegistry;
    }

    @Override
    public Set<String> annotations() {
        return Set.of("javax.inject.Inject", "jakarta.inject.Inject", "io.jbock.simple.Inject");
    }

    @Override
    public Set<? extends Element> process(Map<String, Set<Element>> elementsByAnnotation) {
        try {
            List<Element> elements = elementsByAnnotation.values().stream().flatMap(Collection::stream).collect(Collectors.toList());
            List<ExecutableElement> constructors = ElementFilter.constructorsIn(elements);
            List<ExecutableElement> methods = ElementFilter.methodsIn(elements);
            for (ExecutableElement constructor : constructors) {
                this.executableElementValidator.validate(constructor);
                this.validator.validateConstructor(constructor);
                this.bindingRegistry.register(constructor);
            }
            for (ExecutableElement method : methods) {
                this.executableElementValidator.validate(method);
                this.validator.validateStaticMethod(method);
                this.bindingRegistry.register(method);
            }
            this.checkFields(elements);
        }
        catch (ValidationFailure f) {
            f.writeTo(this.messager);
        }
        return Set.of();
    }

    private void checkFields(List<Element> elements) {
        List<VariableElement> fields = ElementFilter.fieldsIn(elements);
        Iterator<VariableElement> iterator = fields.iterator();
        if (iterator.hasNext()) {
            VariableElement field = iterator.next();
            throw new ValidationFailure("Field injection is not supported", field);
        }
    }
}

