/*
 * Decompiled with CFR 0.152.
 */
package io.jbock.simple.processor.step;

import io.jbock.simple.Component;
import io.jbock.simple.Inject;
import io.jbock.simple.Modulus;
import io.jbock.simple.Provides;
import io.jbock.simple.auto.common.BasicAnnotationProcessor;
import io.jbock.simple.processor.step.BindingRegistry;
import io.jbock.simple.processor.util.ValidationFailure;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.processing.Messager;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.type.TypeKind;
import javax.lang.model.util.ElementFilter;

public class ProvidesStep
implements BasicAnnotationProcessor.Step {
    private final Messager messager;
    private final BindingRegistry bindingRegistry;

    @Inject
    public ProvidesStep(Messager messager, BindingRegistry bindingRegistry) {
        this.messager = messager;
        this.bindingRegistry = bindingRegistry;
    }

    @Override
    public Set<String> annotations() {
        return Set.of(Provides.class.getCanonicalName());
    }

    @Override
    public Set<? extends Element> process(Map<String, Set<Element>> elementsByAnnotation) {
        try {
            List elements = elementsByAnnotation.values().stream().flatMap(Collection::stream).collect(Collectors.toList());
            List<ExecutableElement> methods = ElementFilter.methodsIn(elements);
            for (ExecutableElement m : methods) {
                if (!m.getModifiers().contains((Object)Modifier.STATIC)) {
                    throw new ValidationFailure("The @Provides method must be static", m);
                }
                if (m.getReturnType().getKind() == TypeKind.VOID) {
                    throw new ValidationFailure("The @Provides method may not return void", m);
                }
                Element enclosing = m.getEnclosingElement();
                if (enclosing.getAnnotation(Component.class) == null && enclosing.getAnnotation(Modulus.class) == null) {
                    throw new ValidationFailure("The @Provides method must be nested inside a @Component or @Modulus", m);
                }
                this.bindingRegistry.register(m);
            }
        }
        catch (ValidationFailure f) {
            f.writeTo(this.messager);
        }
        return Set.of();
    }
}

