/*
 * Decompiled with CFR 0.152.
 */
package io.jbock.simple.processor.util;

import io.jbock.simple.javapoet.TypeName;
import io.jbock.simple.processor.util.Visitors;
import java.util.stream.Collectors;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;

public final class Printing {
    public static final String INDENT = "    ";
    public static final String DOUBLE_INDENT = "        ";

    public static String bindingElementToString(Element element) {
        if (element.getKind() == ElementKind.PARAMETER) {
            return Visitors.PARAMETER_VISITOR.visit(element).getSimpleName().toString();
        }
        ExecutableElement executableElement = Visitors.EXECUTABLE_ELEMENT_VISITOR.visit(element);
        if (executableElement == null) {
            throw new UnsupportedOperationException("Can't determine string for element " + element);
        }
        StringBuilder result = Printing.enclosingTypeAndMemberName(executableElement);
        result.append(executableElement.getParameters().stream().map(parameter -> TypeName.get(parameter.asType()).toString()).collect(Collectors.joining(", ", "(", ")")));
        return result.toString();
    }

    private static String enclosingElementToString(Element element) {
        if (!element.getKind().isClass() && !element.getKind().isInterface()) {
            return element.toString();
        }
        return Visitors.TYPE_ELEMENT_VISITOR.visit(element).getSimpleName().toString();
    }

    private static StringBuilder enclosingTypeAndMemberName(ExecutableElement element) {
        StringBuilder name = new StringBuilder(Printing.enclosingElementToString(element.getEnclosingElement()));
        if (element.getKind() != ElementKind.CONSTRUCTOR) {
            name.append('.').append(Printing.getSimpleName(element));
        }
        return name;
    }

    private static String getSimpleName(Element element) {
        if (element.getKind().isInterface() || element.getKind().isClass()) {
            return Visitors.TYPE_ELEMENT_VISITOR.visit(element).getSimpleName().toString();
        }
        if (element.getKind() == ElementKind.METHOD) {
            return Visitors.EXECUTABLE_ELEMENT_VISITOR.visit(element).getSimpleName().toString();
        }
        if (element.getKind() == ElementKind.CONSTRUCTOR) {
            return "<init>";
        }
        return element.toString();
    }

    private Printing() {
    }
}

