/*
 * Decompiled with CFR 0.152.
 */
package io.jbock.simple.processor.util;

import io.jbock.simple.Inject;
import io.jbock.simple.processor.util.ClearableCache;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.Elements;

public final class SafeElements
implements ClearableCache {
    private final Elements elements;
    private final Map<String, TypeElement> typeElementCache = new HashMap<String, TypeElement>();

    @Inject
    public SafeElements(Elements elements) {
        this.elements = elements;
    }

    public TypeElement getTypeElement(String name) {
        TypeElement fromCache = this.typeElementCache.get(name);
        if (fromCache != null) {
            return fromCache;
        }
        if (this.typeElementCache.containsKey(name)) {
            return null;
        }
        TypeElement result = this.elements.getTypeElement(name);
        this.typeElementCache.put(name, result);
        return result;
    }

    public List<? extends Element> getAllMembers(TypeElement element) {
        return this.elements.getAllMembers(element);
    }

    public Map<? extends ExecutableElement, ? extends AnnotationValue> getElementValuesWithDefaults(AnnotationMirror a) {
        return this.elements.getElementValuesWithDefaults(a);
    }

    @Override
    public void clearCache() {
        this.typeElementCache.clear();
    }
}

