/*
 * Decompiled with CFR 0.152.
 */
package io.jbock.simple.processor.util;

import io.jbock.simple.javapoet.TypeName;
import io.jbock.simple.processor.util.SafeElements;
import io.jbock.simple.processor.util.SafeTypes;
import io.jbock.simple.processor.util.Suppliers;
import io.jbock.simple.processor.util.Visitors;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.IntSupplier;
import java.util.stream.Collectors;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.type.DeclaredType;

public final class SimpleAnnotation {
    private final DeclaredType annotationType;
    private final List<AnnotationValue> values;
    private final SafeTypes types;
    private final IntSupplier hashCode = Suppliers.memoizeInt(() -> SimpleAnnotation.computeHashCode(this.annotationType(), this.values()));

    private SimpleAnnotation(DeclaredType annotationType, List<AnnotationValue> values, SafeTypes types) {
        this.annotationType = annotationType;
        this.values = values;
        this.types = types;
    }

    public static SimpleAnnotation create(AnnotationMirror mirror, SafeElements elements, SafeTypes types) {
        DeclaredType annotationType = mirror.getAnnotationType();
        ArrayList<AnnotationValue> values = new ArrayList<AnnotationValue>(elements.getElementValuesWithDefaults(mirror).values());
        return new SimpleAnnotation(annotationType, values, types);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SimpleAnnotation that = (SimpleAnnotation)o;
        if (!this.types.isSameType(this.annotationType, that.annotationType)) {
            return false;
        }
        if (this.values.size() != that.values.size()) {
            return false;
        }
        for (int i = 0; i < this.values.size(); ++i) {
            if (Objects.equals(this.values.get(i).getValue(), that.values.get(i).getValue())) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return this.hashCode.getAsInt();
    }

    private static int computeHashCode(DeclaredType annotationType, List<AnnotationValue> values) {
        int[] result = new int[values.size() + 1];
        result[0] = TypeName.get(annotationType).hashCode();
        for (int i = 0; i < values.size(); ++i) {
            result[i + 1] = Objects.hashCode(values.get(i).getValue());
        }
        return Arrays.hashCode(result);
    }

    public String toString() {
        String simpleName = Visitors.TYPE_ELEMENT_VISITOR.visit(this.annotationType.asElement()).getSimpleName().toString();
        if (this.values.isEmpty()) {
            return simpleName;
        }
        return simpleName + this.values.stream().map(Objects::toString).collect(Collectors.joining(", ", "(", ")"));
    }

    private DeclaredType annotationType() {
        return this.annotationType;
    }

    private List<AnnotationValue> values() {
        return this.values;
    }
}

