/*
 * Decompiled with CFR 0.152.
 */
package io.jbock.simple.processor.util;

import java.util.function.IntSupplier;
import java.util.function.Supplier;

public final class Suppliers {
    public static <T> Supplier<T> memoize(Supplier<T> delegate) {
        return new Cache<T>(delegate);
    }

    public static IntSupplier memoizeInt(IntSupplier delegate) {
        return new IntCache(delegate);
    }

    private Suppliers() {
    }

    private static final class Cache<T>
    implements Supplier<T> {
        boolean initialized;
        T value;
        final Supplier<T> delegate;

        Cache(Supplier<T> delegate) {
            this.delegate = delegate;
        }

        @Override
        public T get() {
            if (!this.initialized) {
                this.initialized = true;
                this.value = this.delegate.get();
            }
            return this.value;
        }
    }

    private static final class IntCache
    implements IntSupplier {
        private boolean initialized;
        private int value;
        private final IntSupplier delegate;

        IntCache(IntSupplier delegate) {
            this.delegate = delegate;
        }

        @Override
        public int getAsInt() {
            if (!this.initialized) {
                this.initialized = true;
                this.value = this.delegate.getAsInt();
            }
            return this.value;
        }
    }
}

