/*
 * Decompiled with CFR 0.152.
 */
package io.jbock.simple.processor.util;

import io.jbock.simple.Inject;
import io.jbock.simple.processor.util.ProviderType;
import io.jbock.simple.processor.util.SafeElements;
import io.jbock.simple.processor.util.SafeTypes;
import io.jbock.simple.processor.util.Visitors;
import java.util.List;
import java.util.Optional;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;

public final class TypeTool {
    private final SafeElements elements;
    private final SafeTypes types;

    @Inject
    public TypeTool(SafeElements elements, SafeTypes types) {
        this.elements = elements;
        this.types = types;
    }

    public boolean isSameType(TypeMirror mirror, Class<?> cl) {
        return this.isSameType(mirror, cl.getCanonicalName());
    }

    public boolean isSameType(TypeMirror mirror, String canonicalName) {
        TypeElement typeElement = this.elements.getTypeElement(canonicalName);
        if (typeElement == null) {
            return false;
        }
        return this.types.isSameType(mirror, typeElement.asType());
    }

    public boolean isSameType(TypeMirror mirror, TypeMirror other) {
        return this.types.isSameType(mirror, other);
    }

    public boolean hasInjectAnnotation(Element m) {
        if (m.getKind() != ElementKind.CONSTRUCTOR && m.getKind() != ElementKind.METHOD) {
            return false;
        }
        List<? extends AnnotationMirror> mirrors = m.getAnnotationMirrors();
        if (mirrors.isEmpty()) {
            return false;
        }
        return mirrors.stream().anyMatch(mirror -> {
            DeclaredType annotationType = mirror.getAnnotationType();
            return this.isSameType((TypeMirror)annotationType, "javax.inject.Inject") || this.isSameType((TypeMirror)annotationType, "jakarta.inject.Inject") || this.isSameType((TypeMirror)annotationType, "io.jbock.simple.Inject");
        });
    }

    public boolean hasQualifierAnnotation(Element m) {
        List<? extends AnnotationMirror> mirrors = m.getAnnotationMirrors();
        if (mirrors.isEmpty()) {
            return false;
        }
        return mirrors.stream().anyMatch(mirror -> {
            DeclaredType annotationType = mirror.getAnnotationType();
            return this.isSameType((TypeMirror)annotationType, "io.jbock.simple.Qualifier") || this.isSameType((TypeMirror)annotationType, "jakarta.inject.Qualifier") || this.isSameType((TypeMirror)annotationType, "javax.inject.Qualifier");
        });
    }

    public Optional<ProviderType> getProviderType(TypeMirror mirror) {
        return this.getSingleTypeArgument(mirror, this.elements.getTypeElement("javax.inject.Provider")).map(m -> new ProviderType(ProviderType.ProviderKind.JAVAX, (TypeMirror)m)).or(() -> this.getSingleTypeArgument(mirror, this.elements.getTypeElement("jakarta.inject.Provider")).map(m -> new ProviderType(ProviderType.ProviderKind.JAKARTA, (TypeMirror)m))).or(() -> this.getSingleTypeArgument(mirror, this.elements.getTypeElement("io.jbock.simple.Provider")).map(m -> new ProviderType(ProviderType.ProviderKind.SIMPLE, (TypeMirror)m)));
    }

    private Optional<TypeMirror> getSingleTypeArgument(TypeMirror mirror, TypeElement someClass) {
        if (someClass == null) {
            return Optional.empty();
        }
        DeclaredType declaredType = Visitors.DECLARED_TYPE_VISITOR.visit(mirror);
        if (declaredType == null) {
            return Optional.empty();
        }
        List<? extends TypeMirror> typeArguments = declaredType.getTypeArguments();
        if (typeArguments.size() != 1) {
            return Optional.empty();
        }
        if (this.types.isSameType(this.types.erasure(declaredType), this.types.erasure(someClass.asType()))) {
            return Optional.of(typeArguments.get(0));
        }
        return Optional.empty();
    }

    public SafeElements elements() {
        return this.elements;
    }

    public SafeTypes types() {
        return this.types;
    }
}

