/*
 * Decompiled with CFR 0.152.
 */
package io.jbock.simple.processor.validation;

import io.jbock.simple.Component;
import io.jbock.simple.Inject;
import io.jbock.simple.Modulus;
import io.jbock.simple.processor.binding.InjectBindingScanner;
import io.jbock.simple.processor.util.TypeTool;
import io.jbock.simple.processor.util.Util;
import io.jbock.simple.processor.util.ValidationFailure;
import io.jbock.simple.processor.util.Visitors;
import java.util.List;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;

public final class InjectBindingValidator {
    private final TypeTool tool;
    private final InjectBindingScanner injectBindingScanner;

    @Inject
    public InjectBindingValidator(TypeTool tool, InjectBindingScanner injectBindingScanner) {
        this.tool = tool;
        this.injectBindingScanner = injectBindingScanner;
    }

    public void validateConstructor(ExecutableElement element) {
        this.validate(element);
    }

    public void validateStaticMethod(ExecutableElement method) {
        this.validate(method);
        if (!method.getModifiers().contains((Object)Modifier.STATIC)) {
            throw new ValidationFailure("The factory method must be static", method);
        }
        if (method.getReturnType().getKind() == TypeKind.VOID) {
            throw new ValidationFailure("The factory method may not return void", method);
        }
        if (!(this.isSibling(method) || this.isInComponent(method) || this.isInModule(method))) {
            throw new ValidationFailure("The factory method must return the type of its enclosing class", method);
        }
    }

    private boolean isInComponent(ExecutableElement method) {
        TypeElement typeElement = Visitors.TYPE_ELEMENT_VISITOR.visit(method.getEnclosingElement());
        return typeElement.getAnnotation(Component.class) != null;
    }

    private boolean isInModule(ExecutableElement method) {
        TypeElement typeElement = Visitors.TYPE_ELEMENT_VISITOR.visit(method.getEnclosingElement());
        return typeElement.getAnnotation(Modulus.class) != null;
    }

    private boolean isSibling(ExecutableElement method) {
        TypeElement typeElement = Visitors.TYPE_ELEMENT_VISITOR.visit(method.getEnclosingElement());
        List hierarchyRt = this.tool.types().asElement(method.getReturnType()).map(Visitors.TYPE_ELEMENT_VISITOR::visit).map(Util::getWithEnclosing).orElse(List.of());
        for (TypeElement r : hierarchyRt) {
            if (!r.equals(typeElement)) continue;
            return true;
        }
        return false;
    }

    private void validate(ExecutableElement element) {
        TypeElement typeElement = Visitors.TYPE_ELEMENT_VISITOR.visit(element.getEnclosingElement());
        if (!typeElement.getTypeParameters().isEmpty()) {
            throw new ValidationFailure("Type parameters are not allowed on element", typeElement);
        }
        List<ExecutableElement> methods = this.injectBindingScanner.scan(typeElement);
        for (ExecutableElement m : methods) {
            if (m.getAnnotationMirrors().stream().filter(mirror -> {
                DeclaredType annotationType = mirror.getAnnotationType();
                return this.tool.isSameType((TypeMirror)annotationType, "javax.inject.Inject") || this.tool.isSameType((TypeMirror)annotationType, "jakarta.inject.Inject") || this.tool.isSameType((TypeMirror)annotationType, "io.jbock.simple.Inject");
            }).count() < 2L) continue;
            throw new ValidationFailure("Duplicate inject annotation", m);
        }
    }
}

