/*
 * Decompiled with CFR 0.152.
 */
package io.jbock.simple.processor.validation;

import io.jbock.simple.Inject;
import io.jbock.simple.processor.util.ValidationFailure;
import io.jbock.simple.processor.util.Visitors;
import java.util.ArrayList;
import java.util.List;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;

public final class TypeElementValidator {
    @Inject
    public TypeElementValidator() {
    }

    public void validate(TypeElement element) {
        if (element.getKind() != ElementKind.INTERFACE) {
            throw new ValidationFailure("The annotated class must be an interface", element);
        }
        if (!element.getTypeParameters().isEmpty()) {
            throw new ValidationFailure("Type parameters are not allowed here", element);
        }
        this.checkNesting(element);
    }

    public void checkNesting(TypeElement classToCheck) {
        if (classToCheck.getNestingKind().isNested() && !classToCheck.getModifiers().contains((Object)Modifier.STATIC)) {
            throw new ValidationFailure("nested class '" + classToCheck.getSimpleName() + "' must be static", classToCheck);
        }
        if (classToCheck.getModifiers().contains((Object)Modifier.PRIVATE)) {
            throw new ValidationFailure("class '" + classToCheck.getSimpleName() + " may not be private", classToCheck);
        }
        for (TypeElement element : this.getEnclosingElements(classToCheck)) {
            if (element.getModifiers().contains((Object)Modifier.PRIVATE)) {
                throw new ValidationFailure("enclosing class '" + element.getSimpleName() + "' may not be private", classToCheck);
            }
            if (!element.getNestingKind().isNested() || element.getModifiers().contains((Object)Modifier.STATIC)) continue;
            throw new ValidationFailure("nested class '" + element.getSimpleName() + "' must be static", classToCheck);
        }
    }

    private List<TypeElement> getEnclosingElements(TypeElement sourceElement) {
        TypeElement enclosing;
        if (!sourceElement.getNestingKind().isNested()) {
            return List.of();
        }
        ArrayList<TypeElement> result = new ArrayList<TypeElement>();
        TypeElement current = sourceElement;
        while (current.getNestingKind().isNested() && (enclosing = Visitors.TYPE_ELEMENT_VISITOR.visit(current.getEnclosingElement())) != null) {
            result.add(enclosing);
            current = enclosing;
        }
        return result;
    }
}

