/*
 * Decompiled with CFR 0.152.
 */
package io.jbock.simple.processor.writing;

import io.jbock.simple.Inject;
import io.jbock.simple.javapoet.CodeBlock;
import io.jbock.simple.javapoet.FieldSpec;
import io.jbock.simple.javapoet.MethodSpec;
import io.jbock.simple.javapoet.ParameterSpec;
import io.jbock.simple.javapoet.TypeName;
import io.jbock.simple.javapoet.TypeSpec;
import io.jbock.simple.processor.binding.Binding;
import io.jbock.simple.processor.binding.BuilderElement;
import io.jbock.simple.processor.binding.ComponentElement;
import io.jbock.simple.processor.binding.Key;
import io.jbock.simple.processor.binding.ParameterBinding;
import io.jbock.simple.processor.writing.Context;
import io.jbock.simple.processor.writing.MockBuilder;
import io.jbock.simple.processor.writing.NamedBinding;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.lang.model.element.Modifier;
import javax.lang.model.type.TypeMirror;

public final class BuilderImpl {
    private final ComponentElement component;
    private final Map<Key, NamedBinding> sorted;
    private final Function<Key, ParameterSpec> names;

    @Inject
    public BuilderImpl(ComponentElement component, Context context) {
        this.component = component;
        this.sorted = context.sorted();
        this.names = context.names();
    }

    TypeSpec generate(BuilderElement builder, MockBuilder mockBuilder) {
        TypeMirror builderType = builder.element().asType();
        TypeSpec.Builder spec = TypeSpec.classBuilder(builder.generatedClass());
        spec.addFields(this.fields());
        spec.addMethods(this.setterMethods(builder));
        if (this.component.mockBuilder()) {
            spec.addMethod(this.generateWithMocksMethod(mockBuilder));
        }
        spec.addModifiers(Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL);
        spec.addSuperinterface(builderType);
        spec.addMethod(this.generateBuildMethod(builder));
        return spec.build();
    }

    private MethodSpec generateBuildMethod(BuilderElement builder) {
        MethodSpec.Builder buildMethod = MethodSpec.methodBuilder(builder.buildMethod().getSimpleName().toString());
        for (NamedBinding namedBinding : this.sorted.values()) {
            Binding b = namedBinding.binding();
            Key key = b.key();
            CodeBlock invocation = b.invocation(this.names, this.sorted, true);
            ParameterSpec param = this.names.apply(key);
            if (b instanceof ParameterBinding) continue;
            buildMethod.addStatement("$T $N = $L", key.typeName(), param, invocation);
        }
        buildMethod.addAnnotation(Override.class);
        buildMethod.addModifiers(builder.buildMethod().getModifiers().stream().filter(m -> m == Modifier.PUBLIC || m == Modifier.PROTECTED).collect(Collectors.toList()));
        buildMethod.returns(TypeName.get(this.component.element().asType()));
        buildMethod.addStatement("return new $T($L)", this.component.generatedClass(), this.constructorParameters().stream().collect(CodeBlock.joining(", ")));
        return buildMethod.build();
    }

    private MethodSpec generateWithMocksMethod(MockBuilder mockBuilder) {
        MethodSpec.Builder method = MethodSpec.methodBuilder("withMocks");
        ArrayList<CodeBlock> constructorParameters = new ArrayList<CodeBlock>();
        for (NamedBinding namedBinding : this.sorted.values()) {
            Binding b = namedBinding.binding();
            if (!(b instanceof ParameterBinding)) continue;
            ParameterSpec param = this.names.apply(b.key());
            constructorParameters.add(CodeBlock.of("this.$N", param));
        }
        if (this.component.publicMockBuilder()) {
            method.addModifiers(Modifier.PUBLIC);
        }
        method.returns(mockBuilder.getClassName());
        method.addStatement("return new $T($L)", mockBuilder.getClassName(), constructorParameters.stream().collect(CodeBlock.joining(", ")));
        return method.build();
    }

    private List<FieldSpec> fields() {
        ArrayList<FieldSpec> result = new ArrayList<FieldSpec>();
        for (NamedBinding namedBinding : this.sorted.values()) {
            Binding b = namedBinding.binding();
            if (!(b instanceof ParameterBinding)) continue;
            result.add(FieldSpec.builder(b.key().typeName(), this.names.apply((Key)b.key()).name, new Modifier[0]).build());
        }
        return result;
    }

    private List<MethodSpec> setterMethods(BuilderElement builder) {
        ArrayList<MethodSpec> result = new ArrayList<MethodSpec>();
        for (NamedBinding namedBinding : this.sorted.values()) {
            Binding b = namedBinding.binding();
            if (!(b instanceof ParameterBinding)) continue;
            MethodSpec.Builder setterMethod = MethodSpec.methodBuilder(b.element().getSimpleName().toString());
            setterMethod.addAnnotation(Override.class);
            setterMethod.addParameter(this.names.apply(b.key()));
            setterMethod.addStatement("this.$1N = $1N", this.names.apply(b.key()));
            setterMethod.addStatement("return this", new Object[0]);
            setterMethod.returns(builder.generatedClass());
            setterMethod.addModifiers(b.element().getModifiers().stream().filter(m -> m == Modifier.PUBLIC || m == Modifier.PROTECTED).collect(Collectors.toList()));
            result.add(setterMethod.build());
        }
        return result;
    }

    private List<CodeBlock> constructorParameters() {
        ArrayList<CodeBlock> result = new ArrayList<CodeBlock>();
        for (NamedBinding namedBinding : this.sorted.values()) {
            Binding b = namedBinding.binding();
            Key key = b.key();
            if (!namedBinding.isComponentRequest()) continue;
            result.add(CodeBlock.of("$N", this.names.apply(key)));
        }
        return result;
    }
}

