/*
 * Decompiled with CFR 0.152.
 */
package io.jbock.simple.processor.writing;

import io.jbock.simple.Inject;
import io.jbock.simple.javapoet.AnnotationSpec;
import io.jbock.simple.javapoet.CodeBlock;
import io.jbock.simple.javapoet.FieldSpec;
import io.jbock.simple.javapoet.MethodSpec;
import io.jbock.simple.javapoet.ParameterSpec;
import io.jbock.simple.javapoet.TypeName;
import io.jbock.simple.javapoet.TypeSpec;
import io.jbock.simple.processor.SimpleComponentProcessor;
import io.jbock.simple.processor.binding.Binding;
import io.jbock.simple.processor.binding.BuilderElement;
import io.jbock.simple.processor.binding.ComponentElement;
import io.jbock.simple.processor.binding.DependencyRequest;
import io.jbock.simple.processor.binding.FactoryElement;
import io.jbock.simple.processor.binding.Key;
import io.jbock.simple.processor.binding.KeyFactory;
import io.jbock.simple.processor.binding.ParameterBinding;
import io.jbock.simple.processor.writing.BuilderImpl;
import io.jbock.simple.processor.writing.Context;
import io.jbock.simple.processor.writing.FactoryImpl;
import io.jbock.simple.processor.writing.MockBuilder;
import io.jbock.simple.processor.writing.NamedBinding;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.processing.Generated;
import javax.lang.model.element.Modifier;

public class ComponentImpl {
    private static final String FACTORY_METHOD = "factory";
    private static final String BUILDER_METHOD = "builder";
    private static final String CREATE_METHOD = "create";
    private static final String MOCK_BUILDER_METHOD = "mockBuilder";
    private final KeyFactory keyFactory;
    private final ComponentElement component;
    private final Map<Key, NamedBinding> sorted;
    private final Function<Key, ParameterSpec> names;
    private final MockBuilder mockBuilder;
    private final BuilderImpl builderImpl;
    private final FactoryImpl factoryImpl;
    private final Modifier[] modifiers;

    @Inject
    public ComponentImpl(KeyFactory keyFactory, ComponentElement component, Context context, MockBuilder mockBuilder, BuilderImpl builderImpl, FactoryImpl factoryImpl) {
        this.keyFactory = keyFactory;
        this.component = component;
        this.sorted = context.sorted();
        this.names = context.names();
        this.modifiers = (Modifier[])component.element().getModifiers().stream().filter(m -> m == Modifier.PUBLIC).toArray(Modifier[]::new);
        this.mockBuilder = mockBuilder;
        this.builderImpl = builderImpl;
        this.factoryImpl = factoryImpl;
    }

    public TypeSpec generate() {
        TypeSpec.Builder spec = TypeSpec.classBuilder(this.component.generatedClass()).addModifiers(this.modifiers).addModifiers(Modifier.FINAL).addSuperinterface(this.component.element().asType());
        spec.addFields(this.getFields());
        spec.addMethods(this.generateGetters());
        this.keyFactory.factoryElement().ifPresent(factory -> {
            spec.addMethod(this.generateFactoryMethod((FactoryElement)factory));
            spec.addType(this.factoryImpl.generate((FactoryElement)factory));
            if (this.component.mockBuilder()) {
                spec.addMethod(this.generateMockBuilderMethodFactory());
            }
        });
        this.keyFactory.builderElement().ifPresent(builder -> {
            spec.addMethod(this.generateBuilderMethod((BuilderElement)builder));
            spec.addType(this.builderImpl.generate((BuilderElement)builder, this.mockBuilder));
        });
        if (this.keyFactory.factoryElement().isEmpty() && this.keyFactory.builderElement().isEmpty()) {
            spec.addMethod(this.generateCreateMethod());
            if (this.component.mockBuilder()) {
                spec.addMethod(this.generateMockBuilderMethod());
            }
        }
        if (this.component.mockBuilder()) {
            spec.addType(this.mockBuilder.generate());
        }
        spec.addAnnotation(AnnotationSpec.builder(Generated.class).addMember("value", CodeBlock.of("$S", SimpleComponentProcessor.class.getCanonicalName())).addMember("comments", CodeBlock.of("$S", this.getComments())).build());
        spec.addMethod(this.generateAllParametersConstructor());
        spec.addOriginatingElement(this.component.element());
        return spec.build();
    }

    private List<MethodSpec> generateGetters() {
        ArrayList<MethodSpec> result = new ArrayList<MethodSpec>(this.keyFactory.requests().size());
        for (DependencyRequest r : this.keyFactory.requests()) {
            MethodSpec.Builder method = MethodSpec.methodBuilder(r.requestingElement().getSimpleName().toString());
            method.addStatement("return $L", this.sorted.get(r.key()).name());
            method.returns(r.key().typeName());
            method.addAnnotation(Override.class);
            method.addModifiers(Modifier.PUBLIC);
            result.add(method.build());
        }
        return result;
    }

    private String getComments() {
        String version = Objects.toString(this.getClass().getPackage().getImplementationVersion(), "");
        return "https://github.com/jbock-java/simple-component" + (String)(version.isEmpty() ? "" : " " + version);
    }

    private MethodSpec generateFactoryMethod(FactoryElement factory) {
        MethodSpec.Builder spec = MethodSpec.methodBuilder(FACTORY_METHOD).addModifiers(Modifier.STATIC).addModifiers(this.modifiers).returns(TypeName.get(factory.element().asType()));
        spec.addStatement("return new $T()", factory.generatedClass());
        return spec.build();
    }

    private MethodSpec generateBuilderMethod(BuilderElement builder) {
        MethodSpec.Builder spec = MethodSpec.methodBuilder(BUILDER_METHOD).addModifiers(Modifier.STATIC).addModifiers(this.modifiers).returns(builder.generatedClass());
        spec.addStatement("return new $T()", builder.generatedClass());
        return spec.build();
    }

    private MethodSpec generateCreateMethod() {
        ArrayList<CodeBlock> constructorParameters = new ArrayList<CodeBlock>();
        MethodSpec.Builder method = MethodSpec.methodBuilder(CREATE_METHOD);
        for (NamedBinding namedBinding : this.sorted.values()) {
            Binding b = namedBinding.binding();
            Key key = b.key();
            CodeBlock invocation = b.invocation(this.names, this.sorted, true);
            ParameterSpec param = this.names.apply(key);
            if (namedBinding.isComponentRequest()) {
                constructorParameters.add(CodeBlock.of("$N", this.names.apply(key)));
            }
            method.addStatement("$T $N = $L", key.typeName(), param, invocation);
        }
        return method.addModifiers(Modifier.STATIC).addModifiers(this.modifiers).returns(TypeName.get(this.component.element().asType())).addStatement("return new $T($L)", this.component.generatedClass(), constructorParameters.stream().collect(CodeBlock.joining(", "))).build();
    }

    MethodSpec generateMockBuilderMethod() {
        MethodSpec.Builder method = MethodSpec.methodBuilder(MOCK_BUILDER_METHOD);
        method.addJavadoc("Visible for testing. Do not call this method from production code.", new Object[0]);
        method.addStatement("return new $T()", this.mockBuilder.getClassName());
        method.returns(this.mockBuilder.getClassName());
        method.addModifiers(Modifier.STATIC);
        if (this.component.publicMockBuilder()) {
            method.addModifiers(this.modifiers);
        }
        return method.build();
    }

    MethodSpec generateMockBuilderMethodFactory() {
        MethodSpec.Builder method = MethodSpec.methodBuilder(MOCK_BUILDER_METHOD);
        ArrayList<CodeBlock> constructorParameters = new ArrayList<CodeBlock>();
        for (NamedBinding namedBinding : this.sorted.values()) {
            Binding b = namedBinding.binding();
            if (!(b instanceof ParameterBinding)) continue;
            ParameterSpec param = this.names.apply(b.key());
            constructorParameters.add(CodeBlock.of("$N", param));
        }
        if (this.component.publicMockBuilder()) {
            method.addModifiers(Modifier.PUBLIC);
        }
        method.addParameters(this.factoryImpl.parameters());
        method.returns(this.mockBuilder.getClassName());
        method.addStatement("return new $T($L)", this.mockBuilder.getClassName(), constructorParameters.stream().collect(CodeBlock.joining(", ")));
        return method.build();
    }

    private List<FieldSpec> getFields() {
        ArrayList<FieldSpec> fields = new ArrayList<FieldSpec>();
        for (NamedBinding namedBinding : this.sorted.values()) {
            if (!namedBinding.isComponentRequest()) continue;
            TypeName type = namedBinding.binding().key().typeName();
            FieldSpec field = FieldSpec.builder(type, namedBinding.name(), Modifier.PRIVATE, Modifier.FINAL).build();
            fields.add(field);
        }
        return fields;
    }

    private MethodSpec generateAllParametersConstructor() {
        MethodSpec.Builder constructor = MethodSpec.constructorBuilder().addModifiers(Modifier.PRIVATE);
        for (NamedBinding namedBinding : this.sorted.values()) {
            if (!namedBinding.isComponentRequest()) continue;
            ParameterSpec param = this.names.apply(namedBinding.binding().key());
            constructor.addParameter(param);
            constructor.addStatement("this.$1N = $1N", param);
        }
        return constructor.build();
    }
}

