/*
 * Decompiled with CFR 0.152.
 */
package io.jbock.simple.processor.writing;

import io.jbock.simple.Modulus;
import io.jbock.simple.javapoet.ParameterSpec;
import io.jbock.simple.processor.binding.Binding;
import io.jbock.simple.processor.binding.Key;
import io.jbock.simple.processor.binding.KeyFactory;
import io.jbock.simple.processor.util.UniqueNameSet;
import io.jbock.simple.processor.writing.NamedBinding;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Modifier;

@Modulus
public interface ContextModule {
    public static Map<Key, NamedBinding> addNames(KeyFactory keyFactory, List<Binding> bindings) {
        UniqueNameSet uniqueNameSet = new UniqueNameSet();
        uniqueNameSet.claim("mockBuilder");
        uniqueNameSet.claim("withMocks");
        uniqueNameSet.claim("build");
        LinkedHashMap<Key, NamedBinding> result = new LinkedHashMap<Key, NamedBinding>();
        for (Binding b : bindings) {
            String name = uniqueNameSet.getUniqueName(ContextModule.validJavaName(b.suggestedVariableName()));
            String auxName = uniqueNameSet.getUniqueName(name + "_isSet");
            result.put(b.key(), new NamedBinding(b, name, auxName, keyFactory.isComponentRequest(b)));
        }
        return result;
    }

    public static Function<Key, ParameterSpec> createNames(Map<Key, NamedBinding> sorted) {
        HashMap cache = new HashMap();
        return key -> cache.computeIfAbsent(key, k -> {
            String name = ((NamedBinding)sorted.get(k)).name();
            return ParameterSpec.builder(k.typeName(), name, new Modifier[0]).build();
        });
    }

    private static String validJavaName(String name) {
        if (SourceVersion.isIdentifier(name)) {
            return ContextModule.protectAgainstKeywords(name);
        }
        StringBuilder newName = new StringBuilder(name.length());
        char firstChar = name.charAt(0);
        if (!Character.isJavaIdentifierStart(firstChar)) {
            newName.append('_');
        }
        name.chars().forEach(c -> newName.append(Character.isJavaIdentifierPart(c) ? c : 95));
        return newName.toString();
    }

    private static String protectAgainstKeywords(String candidateName) {
        switch (candidateName) {
            case "package": {
                return "pkg";
            }
            case "boolean": 
            case "byte": {
                return "b";
            }
            case "double": {
                return "d";
            }
            case "int": {
                return "i";
            }
            case "short": {
                return "s";
            }
            case "char": {
                return "c";
            }
            case "void": {
                return "v";
            }
            case "class": {
                return "clazz";
            }
            case "float": {
                return "f";
            }
            case "long": {
                return "l";
            }
        }
        return SourceVersion.isKeyword(candidateName) ? candidateName + "_" : candidateName;
    }
}

