/*
 * Decompiled with CFR 0.152.
 */
package io.jbock.simple.processor.writing;

import io.jbock.simple.Inject;
import io.jbock.simple.javapoet.CodeBlock;
import io.jbock.simple.javapoet.MethodSpec;
import io.jbock.simple.javapoet.ParameterSpec;
import io.jbock.simple.javapoet.TypeName;
import io.jbock.simple.javapoet.TypeSpec;
import io.jbock.simple.processor.binding.Binding;
import io.jbock.simple.processor.binding.ComponentElement;
import io.jbock.simple.processor.binding.FactoryElement;
import io.jbock.simple.processor.binding.Key;
import io.jbock.simple.processor.binding.ParameterBinding;
import io.jbock.simple.processor.writing.Context;
import io.jbock.simple.processor.writing.NamedBinding;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;

public final class FactoryImpl {
    private final ComponentElement component;
    private final Map<Key, NamedBinding> sorted;
    private final Function<Key, ParameterSpec> names;

    @Inject
    public FactoryImpl(ComponentElement component, Context context) {
        this.component = component;
        this.sorted = context.sorted();
        this.names = context.names();
    }

    TypeSpec generate(FactoryElement factory) {
        TypeSpec.Builder spec = TypeSpec.classBuilder(factory.generatedClass());
        spec.addModifiers(Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL);
        spec.addSuperinterface(factory.element().asType());
        ExecutableElement abstractMethod = factory.singleAbstractMethod();
        MethodSpec.Builder method = MethodSpec.methodBuilder(abstractMethod.getSimpleName().toString());
        method.addAnnotation(Override.class);
        method.addModifiers(abstractMethod.getModifiers().stream().filter(m -> m == Modifier.PUBLIC || m == Modifier.PROTECTED).collect(Collectors.toList()));
        method.returns(TypeName.get(this.component.element().asType()));
        for (NamedBinding namedBinding : this.sorted.values()) {
            Binding b = namedBinding.binding();
            Key key = b.key();
            CodeBlock invocation = b.invocation(this.names, this.sorted, false);
            ParameterSpec param = this.names.apply(key);
            if (b instanceof ParameterBinding) continue;
            method.addStatement("$T $N = $L", key.typeName(), param, invocation);
        }
        method.addParameters(this.parameters());
        method.addStatement("return new $T($L)", this.component.generatedClass(), this.constructorParameters().stream().collect(CodeBlock.joining(", ")));
        spec.addMethod(method.build());
        return spec.build();
    }

    private List<CodeBlock> constructorParameters() {
        ArrayList<CodeBlock> result = new ArrayList<CodeBlock>();
        for (NamedBinding namedBinding : this.sorted.values()) {
            Binding b = namedBinding.binding();
            Key key = b.key();
            if (!namedBinding.isComponentRequest()) continue;
            result.add(CodeBlock.of("$N", this.names.apply(key)));
        }
        return result;
    }

    List<ParameterSpec> parameters() {
        ArrayList<ParameterSpec> result = new ArrayList<ParameterSpec>();
        for (NamedBinding namedBinding : this.sorted.values()) {
            Binding b = namedBinding.binding();
            Key key = b.key();
            if (!(b instanceof ParameterBinding)) continue;
            result.add(this.names.apply(key));
        }
        return result;
    }
}

