/*
 * Decompiled with CFR 0.152.
 */
package io.jbock.simple.processor.writing;

import io.jbock.simple.Inject;
import io.jbock.simple.javapoet.ClassName;
import io.jbock.simple.javapoet.CodeBlock;
import io.jbock.simple.javapoet.FieldSpec;
import io.jbock.simple.javapoet.MethodSpec;
import io.jbock.simple.javapoet.ParameterSpec;
import io.jbock.simple.javapoet.TypeName;
import io.jbock.simple.javapoet.TypeSpec;
import io.jbock.simple.processor.binding.Binding;
import io.jbock.simple.processor.binding.ComponentElement;
import io.jbock.simple.processor.binding.Key;
import io.jbock.simple.processor.binding.ParameterBinding;
import io.jbock.simple.processor.writing.Context;
import io.jbock.simple.processor.writing.NamedBinding;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.lang.model.element.Modifier;

public final class MockBuilder {
    private final ComponentElement component;
    private final Map<Key, NamedBinding> sorted;
    private final Function<Key, ParameterSpec> names;
    private final Modifier[] modifiers;

    @Inject
    public MockBuilder(ComponentElement component, Context context) {
        this.component = component;
        this.sorted = context.sorted();
        this.names = context.names();
        this.modifiers = (Modifier[])component.element().getModifiers().stream().filter(m -> m == Modifier.PUBLIC).toArray(Modifier[]::new);
    }

    TypeSpec generate() {
        TypeSpec.Builder spec = TypeSpec.classBuilder(this.getClassName()).addModifiers(this.modifiers).addModifiers(Modifier.STATIC, Modifier.FINAL);
        spec.addMethod(this.buildMethod());
        spec.addFields(this.getFinalFields());
        spec.addFields(this.getFields());
        spec.addMethods(this.getMethods());
        spec.addMethod(this.generateConstructor());
        return spec.build();
    }

    private MethodSpec generateConstructor() {
        MethodSpec.Builder constructor = MethodSpec.constructorBuilder().addModifiers(Modifier.PRIVATE);
        for (NamedBinding namedBinding : this.sorted.values()) {
            Binding b = namedBinding.binding();
            if (!(b instanceof ParameterBinding)) continue;
            Key key = b.key();
            TypeName type = key.typeName();
            FieldSpec field = FieldSpec.builder(type, namedBinding.name(), Modifier.PRIVATE, Modifier.FINAL).build();
            ParameterSpec param = this.names.apply(key);
            constructor.addParameter(param);
            constructor.addStatement("this.$N = $N", field, param);
        }
        return constructor.build();
    }

    ClassName getClassName() {
        return this.component.generatedClass().nestedClass("MockBuilder");
    }

    private MethodSpec buildMethod() {
        MethodSpec.Builder method = MethodSpec.methodBuilder("build");
        method.addModifiers(this.modifiers);
        method.returns(TypeName.get(this.component.element().asType()));
        ArrayList<CodeBlock> constructorParameters = new ArrayList<CodeBlock>();
        for (NamedBinding namedBinding : this.sorted.values()) {
            Binding b = namedBinding.binding();
            Key key = b.key();
            CodeBlock invocation = b.invocation(this.names, this.sorted, true);
            ParameterSpec param = this.names.apply(key);
            if (namedBinding.isComponentRequest()) {
                constructorParameters.add(CodeBlock.of("$N", this.names.apply(key)));
            }
            if (namedBinding.binding() instanceof ParameterBinding) continue;
            if (!key.typeName().isPrimitive()) {
                method.addStatement("$1T $2N = this.$2N != null ? this.$2N : $3L", key.typeName(), param, invocation);
                continue;
            }
            FieldSpec auxField = FieldSpec.builder(TypeName.BOOLEAN, namedBinding.auxName(), Modifier.PRIVATE).build();
            method.addStatement("$1T $2N = this.$3N ? this.$2N : $4L", key.typeName(), param, auxField, invocation);
        }
        method.addStatement("return new $T($L)", this.component.generatedClass(), constructorParameters.stream().collect(CodeBlock.joining(", ")));
        return method.build();
    }

    private List<FieldSpec> getFinalFields() {
        ArrayList<FieldSpec> fields = new ArrayList<FieldSpec>();
        for (NamedBinding namedBinding : this.sorted.values()) {
            if (!(namedBinding.binding() instanceof ParameterBinding)) continue;
            TypeName type = namedBinding.binding().key().typeName();
            FieldSpec field = FieldSpec.builder(type, namedBinding.name(), Modifier.PRIVATE, Modifier.FINAL).build();
            fields.add(field);
        }
        return fields;
    }

    private List<FieldSpec> getFields() {
        ArrayList<FieldSpec> fields = new ArrayList<FieldSpec>();
        for (NamedBinding namedBinding : this.sorted.values()) {
            if (namedBinding.binding() instanceof ParameterBinding) continue;
            TypeName type = namedBinding.binding().key().typeName();
            FieldSpec field = FieldSpec.builder(type, namedBinding.name(), Modifier.PRIVATE).build();
            fields.add(field);
            if (!namedBinding.binding().key().typeName().isPrimitive()) continue;
            FieldSpec auxField = FieldSpec.builder(TypeName.BOOLEAN, namedBinding.auxName(), Modifier.PRIVATE).build();
            fields.add(auxField);
        }
        return fields;
    }

    private List<MethodSpec> getMethods() {
        ArrayList<MethodSpec> methods = new ArrayList<MethodSpec>();
        for (NamedBinding namedBinding : this.sorted.values()) {
            if (namedBinding.binding() instanceof ParameterBinding) continue;
            Binding b = namedBinding.binding();
            Key key = b.key();
            ParameterSpec param = this.names.apply(key);
            MethodSpec.Builder method = MethodSpec.methodBuilder(param.name).addModifiers(this.modifiers).addParameter(param).addStatement("this.$1N = $1N", param);
            if (namedBinding.binding().key().typeName().isPrimitive()) {
                FieldSpec auxField = FieldSpec.builder(TypeName.BOOLEAN, namedBinding.auxName(), Modifier.PRIVATE).build();
                method.addStatement("this.$N = $L", auxField, true);
            }
            method.addStatement("return this", new Object[0]);
            method.returns(this.getClassName());
            methods.add(method.build());
        }
        return methods;
    }
}

