/*
 * Decompiled with CFR 0.152.
 */
package io.github.julwas797.esaapi.common;

import java.util.Objects;
import org.json.JSONObject;

public class SmogEntry {
    private final double averageHumidity;
    private final double averagePressure;
    private final double averageTemperature;
    private final double averagePm10;
    private final double averagePm25;

    public SmogEntry(JSONObject jsonObject) {
        this(jsonObject.optDouble("humidity_avg"), jsonObject.optDouble("pressure_avg"), jsonObject.optDouble("temperature_avg"), jsonObject.optDouble("pm10_avg"), jsonObject.optDouble("pm25_avg"));
    }

    public SmogEntry(double averageHumidity, double averagePressure, double averageTemperature, double averagePm10, double averagePm25) {
        this.averageHumidity = averageHumidity;
        this.averagePressure = averagePressure;
        this.averageTemperature = averageTemperature;
        this.averagePm10 = averagePm10;
        this.averagePm25 = averagePm25;
    }

    public double getAverageHumidity() {
        return this.averageHumidity;
    }

    public double getAveragePressure() {
        return this.averagePressure;
    }

    public double getAverageTemperature() {
        return this.averageTemperature;
    }

    public double getAveragePm10() {
        return this.averagePm10;
    }

    public double getAveragePm25() {
        return this.averagePm25;
    }

    public String toString() {
        return "SmogEntry{averageHumidity=" + this.averageHumidity + ", averagePressure=" + this.averagePressure + ", averageTemperature=" + this.averageTemperature + ", averagePm10=" + this.averagePm10 + ", averagePm25=" + this.averagePm25 + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SmogEntry smogEntry = (SmogEntry)o;
        return Double.compare(smogEntry.averageHumidity, this.averageHumidity) == 0 && Double.compare(smogEntry.averagePressure, this.averagePressure) == 0 && Double.compare(smogEntry.averageTemperature, this.averageTemperature) == 0 && Double.compare(smogEntry.averagePm10, this.averagePm10) == 0 && Double.compare(smogEntry.averagePm25, this.averagePm25) == 0;
    }

    public int hashCode() {
        return Objects.hash(this.averageHumidity, this.averagePressure, this.averageTemperature, this.averagePm10, this.averagePm25);
    }
}

