package io.github.kaststream.api;

import java.io.Serializable;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.state.FunctionInitializationContext;
import org.apache.flink.runtime.state.FunctionSnapshotContext;
import org.apache.flink.streaming.api.functions.sink.SinkFunction;
import org.apache.flink.types.Row;

/**
 * @deprecated This class will be remove in next version
 *     <p>Use {@link io.github.kaststream.api.v2.KastSink} Implement this interface to provide your
 *     own sink function.
 */
public interface KastSink extends Serializable {
  /**
   * Initialization method for the function.
   *
   * @param configuration The configuration containing the parameters attached to the contract
   * @throws Exception The function may throw exceptions which cause the streaming program to fail
   *     and go into recovery.
   */
  public void open(Configuration configuration) throws Exception;

  /**
   * Trigger operation for each stream input.
   *
   * @param row row element coming from an upstream task
   * @param context the SinkFunction.Context
   * @throws Exception The function may throw exceptions which cause the streaming program to fail
   *     and go into recovery.
   */
  public void invoke(Row row, SinkFunction.Context context) throws Exception;

  /**
   * Tear-down method for the user code (ex: clean resources from open).
   *
   * @throws Exception The function may throw exceptions which cause the streaming program to fail
   *     and go into recovery.
   */
  public void close() throws Exception;

  /**
   * This method is called when a snapshot for a checkpoint is requested.
   *
   * @param context a context that allow you for example to manage state
   * @throws Exception The function may throw exceptions which cause the streaming program to fail
   *     and go into recovery.
   */
  public void snapshotState(FunctionSnapshotContext context) throws Exception;

  /**
   * This method is called when the parallel function instance is created during distributed
   * execution. Functions typically set up their state storing data structures in this method.
   *
   * @param context a context that allow you for example to manage state
   * @throws Exception The function may throw exceptions which cause the streaming program to fail
   *     and go into recovery.
   */
  public void initializeState(FunctionInitializationContext context) throws Exception;
}
