/*
 * Decompiled with CFR 0.152.
 */
package io.github.kituin;

import io.github.kituin.ChatImageCode;
import io.github.kituin.ChatImageHandler;
import io.github.kituin.ChatImageHttpHandler;
import io.github.kituin.exception.InvalidChatImageUrlException;
import java.io.File;
import java.io.IOException;

public class ChatImageUrl {
    private final String originalUrl;
    private String httpUrl;
    private final UrlMethod urlMethod;
    private String fileUrl;
    public static NetworkHelper networkHelper;
    public static CachePathHelper cachePathHelper;

    public ChatImageUrl(String url) throws InvalidChatImageUrlException {
        this.originalUrl = url;
        cachePathHelper.check();
        if (this.originalUrl.startsWith("http://") || this.originalUrl.startsWith("https://")) {
            boolean f;
            this.urlMethod = UrlMethod.HTTP;
            this.httpUrl = this.originalUrl;
            if (!ChatImageCode.CACHE_MAP.containsKey(this.httpUrl) && !(f = ChatImageHttpHandler.getInputStream(this.httpUrl))) {
                throw new InvalidChatImageUrlException("Invalid HTTP URL", InvalidChatImageUrlException.InvalidUrlMode.HttpNotFound);
            }
        } else if (this.originalUrl.startsWith("file:///")) {
            this.urlMethod = UrlMethod.FILE;
            this.fileUrl = this.originalUrl.replace("\\", "\\\\").replace("file:///", "");
            File file = new File(this.fileUrl);
            if (!ChatImageCode.CACHE_MAP.containsKey(this.fileUrl)) {
                if (file.exists()) {
                    try {
                        ChatImageHandler.loadFile(this.fileUrl);
                        networkHelper.send(this.fileUrl, file, true);
                    }
                    catch (IOException e) {
                        throw new InvalidChatImageUrlException(this.originalUrl + "<- IOException", InvalidChatImageUrlException.InvalidUrlMode.NotFound);
                    }
                } else {
                    networkHelper.send(this.fileUrl, file, false);
                }
            }
        } else {
            throw new InvalidChatImageUrlException(this.originalUrl + "<- this url is invalid, Please Check again", InvalidChatImageUrlException.InvalidUrlMode.NotFound);
        }
    }

    public String getOriginalUrl() {
        return this.originalUrl;
    }

    public UrlMethod getUrlMethod() {
        return this.urlMethod;
    }

    public String getUrl() {
        if (this.urlMethod == UrlMethod.FILE) {
            return this.fileUrl;
        }
        return this.httpUrl;
    }

    public String toString() {
        return this.originalUrl;
    }

    public static enum UrlMethod {
        FILE,
        HTTP;

    }

    @FunctionalInterface
    public static interface CachePathHelper {
        public void check();
    }

    @FunctionalInterface
    public static interface NetworkHelper {
        public void send(String var1, File var2, boolean var3);
    }
}

