/*
 * Decompiled with CFR 0.152.
 */
package io.github.kituin.ChatImageCode;

import com.google.common.collect.Lists;
import io.github.kituin.ChatImageCode.ChatImageBoolean;
import io.github.kituin.ChatImageCode.ChatImageCode;
import io.github.kituin.ChatImageCode.exception.InvalidChatImageCodeException;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ChatImageCodeTool {
    public static final Pattern cicodesPattern = Pattern.compile("(\\[\\[CICode,(.*?)\\]\\])");
    public static final Pattern cqPattern = Pattern.compile("\\[CQ:image,(.*?)\\]");
    public static final Pattern uriPattern = Pattern.compile("(https?:\\/\\/|file:\\/\\/\\/)([^:<>\\\"]*\\/)([^:<>\\\"]*)\\.(png!thumbnail|bmp|jpe?g|gif)");

    public static void buildMsg(List<Object> texts, Consumer<String> appendString, Consumer<ChatImageCode> appendCode) {
        texts.forEach(obj -> {
            if (obj instanceof String) {
                appendString.accept((String)obj);
            } else if (obj instanceof ChatImageCode) {
                appendCode.accept((ChatImageCode)obj);
            }
        });
    }

    public static List<Object> sliceMsg(String checkedText, boolean isSelf, ChatImageBoolean allString, Consumer<InvalidChatImageCodeException> logger) {
        Matcher m = cicodesPattern.matcher(checkedText);
        ArrayList res = Lists.newArrayList();
        int lastPosition = 0;
        allString.setValue(true);
        while (m.find()) {
            try {
                ChatImageCode image = ChatImageCode.of(m.group(), isSelf);
                if (m.start() != 0) {
                    res.add(checkedText.substring(lastPosition, m.start()));
                }
                lastPosition = m.end();
                res.add(image);
                allString.setValue(false);
            }
            catch (InvalidChatImageCodeException e) {
                logger.accept(e);
            }
        }
        if (lastPosition != checkedText.length()) {
            res.add(checkedText.substring(lastPosition));
        }
        return res;
    }

    public static String checkCQCode(String checkedText) {
        Matcher cqm = cqPattern.matcher((CharSequence)checkedText);
        while (cqm.find()) {
            String[] cqArgs = cqm.group(1).split(",");
            String cq_Url = "";
            for (int i = 0; i < cqArgs.length; ++i) {
                String[] cqParams = cqArgs[i].split("=");
                if (!"url".equals(cqParams[0])) continue;
                cq_Url = cqParams[1];
                break;
            }
            if (cq_Url.isEmpty()) continue;
            checkedText = ((String)checkedText).substring(0, cqm.start()) + String.format("[[CICode,url=%s]]", cq_Url) + ((String)checkedText).substring(cqm.end());
        }
        return checkedText;
    }

    public static String checkImageUri(String checkedText) {
        Matcher matcher = uriPattern.matcher((CharSequence)checkedText);
        while (matcher.find()) {
            String url = matcher.group();
            if (url.isEmpty()) continue;
            checkedText = ((String)checkedText).substring(0, matcher.start()) + String.format("[[CICode,url=%s]]", url) + ((String)checkedText).substring(matcher.end());
        }
        return checkedText;
    }
}

