/*
 * Decompiled with CFR 0.152.
 */
package io.github.kloping.qqbot;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import io.github.kloping.MySpringTool.annotations.AutoStand;
import io.github.kloping.MySpringTool.annotations.Entity;
import io.github.kloping.MySpringTool.interfaces.Logger;
import io.github.kloping.MySpringTool.interfaces.component.ContextManager;
import io.github.kloping.date.FrameUtils;
import io.github.kloping.qqbot.api.message.Message;
import io.github.kloping.qqbot.entitys.Pack;
import io.github.kloping.qqbot.http.BotBase;
import io.github.kloping.qqbot.interfaces.OnAtMessageListener;
import io.github.kloping.qqbot.interfaces.OnCloseListener;
import io.github.kloping.qqbot.interfaces.OnMessageListener;
import io.github.kloping.qqbot.interfaces.OnPackReceive;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.channels.NotYetConnectedException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.java_websocket.client.WebSocketClient;
import org.java_websocket.handshake.ServerHandshake;

@Entity
public class WssWorker
implements Runnable {
    private WebSocketClient webSocket;
    private boolean isFirst = true;
    public Pack jumpPack = new Pack();
    public long heartbeatInterval;
    public int newstId = 1;
    public Pack authPack = null;
    @AutoStand
    ContextManager contextManager;
    @AutoStand
    private BotBase botBase;
    private Logger logger;
    public List<OnMessageListener> listeners = new ArrayList<OnMessageListener>();
    public List<OnAtMessageListener> listeners0 = new ArrayList<OnAtMessageListener>();
    public List<OnCloseListener> listeners1 = new ArrayList<OnCloseListener>();
    private OnPackReceive onPackReceive;
    private boolean uninitialized = true;

    @Override
    public void run() {
        this.init();
        URI u = null;
        try {
            u = new URI(this.botBase.gateway().getUrl());
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        this.webSocket = new WebSocketClient(u){

            public void onOpen(ServerHandshake serverHandshake) {
                WssWorker.this.logger.info("wss opened");
            }

            public void onMessage(String s) {
                if (WssWorker.this.isFirst) {
                    WssWorker.this.logger.info("\u9274\u6743");
                    WssWorker.this.webSocket.send(JSON.toJSONString((Object)WssWorker.this.authPack));
                    WssWorker.this.isFirst = false;
                    Pack pack = (Pack)JSON.parseObject((String)s).toJavaObject(Pack.class);
                    WssWorker.this.heartbeatInterval = ((JSONObject)pack.getD()).getLong("heartbeat_interval");
                    WssWorker.this.jumpPack.setOp(1);
                    FrameUtils.SERVICE.scheduleAtFixedRate(() -> {
                        if (WssWorker.this.newstId != -1) {
                            WssWorker.this.jumpPack.setD(WssWorker.this.newstId);
                        }
                        WssWorker.this.webSocket.send(JSON.toJSONString((Object)WssWorker.this.jumpPack));
                    }, WssWorker.this.heartbeatInterval, WssWorker.this.heartbeatInterval, TimeUnit.MILLISECONDS);
                } else {
                    Pack pack = (Pack)JSON.parseObject((String)s).toJavaObject(Pack.class);
                    if (pack.getS() != null) {
                        WssWorker.this.newstId = pack.getS().intValue();
                    }
                    WssWorker.this.logger.log("receive " + pack);
                    if (WssWorker.this.onPackReceive != null) {
                        try {
                            WssWorker.this.onPackReceive.onReceive(pack);
                        }
                        catch (Throwable e) {
                            e.printStackTrace();
                        }
                    }
                    WssWorker.this.onReceive(pack);
                }
            }

            public void send(String text) throws NotYetConnectedException {
                super.send(text);
                WssWorker.this.logger.log("wss send: " + text);
            }

            public void onClose(int i, String s, boolean b) {
                WssWorker.this.logger.waring("wss closed");
                for (OnCloseListener onCloseListener : WssWorker.this.listeners1) {
                    onCloseListener.onReceive();
                }
            }

            public void onError(Exception e) {
                WssWorker.this.logger.error("wss error");
                e.printStackTrace();
            }
        };
        this.webSocket.run();
    }

    private void onReceive(Pack<JSONObject> pack) {
        String t = pack.getT();
        if (t == null) {
            return;
        }
        JSONObject jo = pack.getD();
        Message m = (Message)jo.toJavaObject(Message.class);
        switch (t) {
            case "MESSAGE_CREATE": {
                Iterator<OnMessageListener> iterator = this.listeners.iterator();
                while (iterator.hasNext()) {
                    iterator.next().onMessage(m);
                }
                return;
            }
            case "AT_MESSAGE_CREATE": {
                Iterator<OnAtMessageListener> iterator0 = this.listeners0.iterator();
                while (iterator0.hasNext()) {
                    iterator0.next().onMessage(m);
                }
                return;
            }
        }
    }

    public void setOnPackReceive(OnPackReceive onPackReceive) {
        this.onPackReceive = onPackReceive;
    }

    private void init() {
        if (!this.uninitialized) {
            return;
        }
        this.uninitialized = false;
        this.authPack = new Pack();
        this.authPack.setOp(2);
        JSONObject jo = new JSONObject();
        jo.put("token", this.contextManager.getContextEntity(String.class, "appid-token"));
        jo.put("intents", this.contextManager.getContextEntity(String.class, "intents"));
        jo.put("shard", this.contextManager.getContextEntity(Integer[].class, "shard"));
        jo.put("properties", new Object());
        this.authPack.setD(jo);
        this.logger = (Logger)this.contextManager.getContextEntity(Logger.class);
    }
}

