/*
 * Decompiled with CFR 0.152.
 */
package io.github.kloping.qqbot;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import io.github.kloping.MySpringTool.annotations.AutoStand;
import io.github.kloping.MySpringTool.annotations.Entity;
import io.github.kloping.MySpringTool.interfaces.Logger;
import io.github.kloping.MySpringTool.interfaces.component.ContextManager;
import io.github.kloping.common.Public;
import io.github.kloping.date.FrameUtils;
import io.github.kloping.qqbot.Resource;
import io.github.kloping.qqbot.api.message.Message;
import io.github.kloping.qqbot.entitys.Pack;
import io.github.kloping.qqbot.http.BotBase;
import io.github.kloping.qqbot.interfaces.OnAtMessageListener;
import io.github.kloping.qqbot.interfaces.OnCloseListener;
import io.github.kloping.qqbot.interfaces.OnMessageDeleteListener;
import io.github.kloping.qqbot.interfaces.OnMessageListener;
import io.github.kloping.qqbot.interfaces.OnOtherEventListener;
import io.github.kloping.qqbot.interfaces.OnPackReceive;
import java.net.URI;
import java.nio.channels.NotYetConnectedException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.java_websocket.client.WebSocketClient;
import org.java_websocket.handshake.ServerHandshake;

@Entity
public class WssWorker
implements Runnable {
    private WebSocketClient webSocket;
    private Boolean isReconnect = false;
    @AutoStand
    ContextManager contextManager;
    @AutoStand
    private BotBase botBase;
    private Logger logger;
    private ScheduledFuture scheduledFuture;
    public Pack jumpPack = new Pack();
    public Pack<JSONObject> authPack = null;
    public String sessionId = "";
    private boolean isFirst = true;
    private boolean connected = false;
    public long heartbeatInterval;
    public int newstId = 1;
    public List<OnMessageListener> messageListeners = new ArrayList<OnMessageListener>();
    public List<OnAtMessageListener> atMessageListeners = new ArrayList<OnAtMessageListener>();
    public List<OnCloseListener> closeListeners = new ArrayList<OnCloseListener>();
    public List<OnOtherEventListener> otherEventListeners = new ArrayList<OnOtherEventListener>();
    public List<OnMessageDeleteListener> messageDeleteListeners = new ArrayList<OnMessageDeleteListener>();
    private OnPackReceive onPackReceive;

    @Override
    public void run() {
        try {
            this.init();
            URI u = new URI(this.botBase.gateway().getUrl());
            this.logger.log("ws url:" + u);
            if (this.webSocket != null && !this.webSocket.isClosed()) {
                this.webSocket.close();
            }
            this.webSocket = new WebSocketClient(u){

                public void onOpen(ServerHandshake serverHandshake) {
                    WssWorker.this.logger.info("wss opened");
                }

                public void onMessage(String s) {
                    if (WssWorker.this.isFirst) {
                        WssWorker.this.logger.info("\u9274\u6743");
                        WssWorker.this.webSocket.send(JSON.toJSONString(WssWorker.this.authPack));
                        WssWorker.this.isFirst = false;
                        Pack pack = (Pack)JSON.parseObject((String)s).toJavaObject(Pack.class);
                        WssWorker.this.heartbeatInterval = ((JSONObject)pack.getD()).getLong("heartbeat_interval");
                        WssWorker.this.jumpPack.setOp(1);
                        if (WssWorker.this.scheduledFuture != null && !WssWorker.this.scheduledFuture.isCancelled()) {
                            WssWorker.this.scheduledFuture.cancel(true);
                        }
                        WssWorker.this.scheduledFuture = FrameUtils.SERVICE.scheduleAtFixedRate(() -> {
                            if (WssWorker.this.newstId != -1) {
                                WssWorker.this.jumpPack.setD(WssWorker.this.newstId);
                            }
                            WssWorker.this.webSocket.send(JSON.toJSONString((Object)WssWorker.this.jumpPack));
                        }, WssWorker.this.heartbeatInterval, WssWorker.this.heartbeatInterval, TimeUnit.MILLISECONDS);
                    } else {
                        Pack pack = (Pack)JSON.parseObject((String)s, Pack.class);
                        WssWorker.this.logger.log("receive " + pack);
                        if (pack.getS() != null) {
                            WssWorker.this.newstId = pack.getS().intValue();
                        }
                        if (pack.getOp().equals(0)) {
                            WssWorker.this.sessionId = ((JSONObject)pack.getD()).getString("session_id");
                        }
                        if (pack.getOp().equals(7)) {
                            WssWorker.this.logger.info("\u670d\u52a1\u7aef\u901a\u77e5\u5ba2\u6237\u7aef\u91cd\u65b0\u8fde\u63a5");
                            WssWorker.this.connected = false;
                            return;
                        }
                        if (WssWorker.this.onPackReceive != null) {
                            try {
                                WssWorker.this.onPackReceive.onReceive(pack);
                            }
                            catch (Throwable e) {
                                e.printStackTrace();
                            }
                        }
                        WssWorker.this.onReceive(pack);
                    }
                }

                public void send(String text) throws NotYetConnectedException {
                    super.send(text);
                    WssWorker.this.logger.log("wss send: " + text);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void onClose(int i, String s, boolean b) {
                    try {
                        WssWorker.this.logger.waring("wss closed");
                        for (OnCloseListener onCloseListener : WssWorker.this.closeListeners) {
                            onCloseListener.onReceive();
                        }
                    }
                    finally {
                        if (WssWorker.this.isReconnect.booleanValue() && !WssWorker.this.connected) {
                            WssWorker.this.reConnect();
                        }
                    }
                }

                public void onError(Exception e) {
                    WssWorker.this.logger.error("wss error");
                    e.printStackTrace();
                }
            };
            this.webSocket.run();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void reConnect() {
        this.isFirst = true;
        this.authPack = new Pack();
        this.jumpPack = new Pack();
        if (Resource.mainFuture != null && !Resource.mainFuture.isCancelled()) {
            Resource.mainFuture.cancel(true);
        }
        Resource.mainFuture = Public.EXECUTOR_SERVICE.submit(() -> this.run());
    }

    private void onReceive(Pack<JSONObject> pack) {
        String t = pack.getT();
        if (t == null) {
            return;
        }
        JSONObject jo = pack.getD();
        Message m = (Message)jo.toJavaObject(Message.class);
        switch (t) {
            case "MESSAGE_CREATE": {
                Iterator<OnMessageListener> iterator0 = this.messageListeners.iterator();
                while (iterator0.hasNext()) {
                    iterator0.next().onMessage(m);
                }
                break;
            }
            case "AT_MESSAGE_CREATE": {
                Iterator<OnAtMessageListener> iterator1 = this.atMessageListeners.iterator();
                while (iterator1.hasNext()) {
                    iterator1.next().onMessage(m);
                }
                break;
            }
            case "MESSAGE_DELETE": {
                Iterator<OnMessageDeleteListener> iterator2 = this.messageDeleteListeners.iterator();
                while (iterator2.hasNext()) {
                    iterator2.next().onDelete(m);
                }
                break;
            }
            case "READY": {
                this.connected = true;
                break;
            }
            default: {
                Iterator<OnOtherEventListener> iterator = this.otherEventListeners.iterator();
                while (iterator.hasNext()) {
                    iterator.next().onEvent(t, m);
                }
                break block6;
            }
        }
    }

    public void setOnPackReceive(OnPackReceive onPackReceive) {
        this.onPackReceive = onPackReceive;
    }

    private void init() {
        this.authPack = new Pack();
        this.authPack.setOp(2);
        JSONObject jo = new JSONObject();
        jo.put("token", this.contextManager.getContextEntity(String.class, "appid-token"));
        jo.put("intents", this.contextManager.getContextEntity(String.class, "intents"));
        jo.put("shard", this.contextManager.getContextEntity(Integer[].class, "shard"));
        jo.put("properties", new Object());
        this.authPack.setD(jo);
        this.logger = (Logger)this.contextManager.getContextEntity(Logger.class);
    }

    public Boolean getReconnect() {
        return this.isReconnect;
    }

    public void setReconnect(Boolean reconnect) {
        this.isReconnect = reconnect;
    }
}

