/*
 * Decompiled with CFR 0.152.
 */
package io.github.kloping.qqbot;

import io.github.kloping.MySpringTool.interfaces.component.ContextManager;
import io.github.kloping.common.Public;
import io.github.kloping.qqbot.Resource;
import io.github.kloping.qqbot.Start0;
import io.github.kloping.qqbot.WssWorker;
import io.github.kloping.qqbot.api.data.ListenerHost;
import io.github.kloping.qqbot.api.qqpd.Guild;
import io.github.kloping.qqbot.api.qqpd.User;
import io.github.kloping.qqbot.entitys.Bot;
import io.github.kloping.qqbot.interfaces.OnAtMessageListener;
import io.github.kloping.qqbot.interfaces.OnMessageDeleteListener;
import io.github.kloping.qqbot.interfaces.OnMessageListener;
import io.github.kloping.qqbot.interfaces.OnOtherEventListener;
import io.github.kloping.qqbot.interfaces.OnPackReceive;
import java.util.HashMap;

public class Starter
implements Runnable {
    public static final String NET_MAIN = "https://api.sgroup.qq.com/";
    public static final String APPID_ID = "appid";
    public static final String TOKEN_ID = "token";
    public static final String AUTH_ID = "appid-token";
    public static final String INTENTS_ID = "intents";
    public static final String SHARD_ID = "shard";
    public static final String PROPERTIES_ID = "properties";
    private String appid;
    private String token;
    private ContextManager contextManager;
    private WssWorker wssWorker;

    public Starter(String appid, String token) {
        this.appid = appid;
        this.token = token;
        Resource.starter = this;
    }

    @Override
    public void run() {
        Resource.APPLICATION.run0(Start0.class);
        this.after();
    }

    protected void after() {
        Resource.APPLICATION.INSTANCE.getContextManager().append((Object)this);
        Resource.APPLICATION.INSTANCE.getContextManager().append((Object)this.appid, APPID_ID);
        Resource.APPLICATION.INSTANCE.getContextManager().append((Object)this.token, TOKEN_ID);
        Resource.APPLICATION.INSTANCE.getContextManager().append((Object)"2081166851", INTENTS_ID);
        Resource.APPLICATION.INSTANCE.getContextManager().append((Object)new Integer[]{0, 1}, SHARD_ID);
        Resource.APPLICATION.INSTANCE.getContextManager().append((Object)("Bot " + this.appid + "." + this.token), AUTH_ID);
        Resource.APPLICATION.INSTANCE.getContextManager().append((Object)Resource.APPLICATION.logger);
        this.contextManager = Resource.APPLICATION.INSTANCE.getContextManager();
        this.wssWorker = (WssWorker)Resource.APPLICATION.INSTANCE.getContextManager().getContextEntity(WssWorker.class);
        this.wssWork();
    }

    protected void wssWork() {
        Resource.mainFuture = Public.EXECUTOR_SERVICE.submit(() -> this.wssWorker.run());
    }

    public ContextManager getContextManager() {
        return this.contextManager;
    }

    public void setOnPackReceive(OnPackReceive onPackReceive) {
        this.wssWorker.setOnPackReceive(onPackReceive);
    }

    public void addListener(OnMessageListener listener) {
        this.wssWorker.messageListeners.add(listener);
    }

    public void addListener(OnAtMessageListener listener) {
        this.wssWorker.atMessageListeners.add(listener);
    }

    public void addListener(OnOtherEventListener listener) {
        this.wssWorker.otherEventListeners.add(listener);
    }

    public void addListener(OnMessageDeleteListener listener) {
        this.wssWorker.messageDeleteListeners.add(listener);
    }

    public Bot getBot() {
        if (Resource.bot == null) {
            User user = Resource.userBase.botInfo();
            HashMap<String, Guild> guildMap = new HashMap<String, Guild>();
            for (Guild guild : Resource.guildBase.getGuilds()) {
                guildMap.put(guild.getId(), guild);
            }
            Resource.bot = new Bot(user, guildMap);
            return Resource.bot;
        }
        return Resource.bot;
    }

    public WssWorker getWssWorker() {
        return this.wssWorker;
    }

    public void registerListenerHost(ListenerHost listenerHost) {
        Resource.LISTENER_HOSTS.add(listenerHost);
    }
}

