/*
 * Decompiled with CFR 0.152.
 */
package io.github.kloping.qqbot.api.qqpd;

import io.github.kloping.qqbot.Resource;
import io.github.kloping.qqbot.api.qqpd.Channel;
import io.github.kloping.qqbot.api.qqpd.Common;
import io.github.kloping.qqbot.api.qqpd.Dms;
import io.github.kloping.qqbot.api.qqpd.DmsRequest;
import io.github.kloping.qqbot.api.qqpd.Member;
import io.github.kloping.qqbot.api.qqpd.interfaces.SessionCreator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Guild
implements SessionCreator {
    private Boolean owner;
    private String joinedAt;
    private String ownerId;
    private String name;
    private String icon;
    private Integer maxMembers;
    private String description;
    private String id;
    private Integer memberCount;

    @Override
    public Dms create(String uid) {
        if (!this.memberMap().containsKey(uid)) {
            return null;
        }
        DmsRequest request = new DmsRequest();
        request.setSourceGuildId(this.id);
        request.setRecipientId(uid);
        return Resource.dmsBase.create(request, Channel.MAP);
    }

    private synchronized void initTemp0() {
        if (!Common.GUILD_MEMBER_TEMP.containsKey(this.id)) {
            Member[] members;
            HashMap<String, Member> map = new HashMap<String, Member>();
            for (Member member : members = Resource.guildBase.getMembers(this.id, 100)) {
                map.put(member.getUser().getId(), member);
            }
            Common.GUILD_MEMBER_TEMP.put(this.id, map);
        }
    }

    private synchronized void initTemp1() {
        if (!Common.GUILD_CHANNEL_TEMP.containsKey(this.id)) {
            Channel[] channels;
            HashMap<String, Channel> map = new HashMap<String, Channel>();
            for (Channel channel : channels = Resource.guildBase.getChannels(this.id)) {
                map.put(channel.getId(), channel);
            }
            Common.GUILD_CHANNEL_TEMP.put(this.id, map);
        }
    }

    public List<Member> members() {
        if (!Common.GUILD_MEMBER_TEMP.containsKey(this.id)) {
            this.initTemp0();
        }
        return new ArrayList<Member>(Common.GUILD_MEMBER_TEMP.get(this.id).values());
    }

    public Map<String, Member> memberMap() {
        if (!Common.GUILD_MEMBER_TEMP.containsKey(this.id)) {
            this.initTemp0();
        }
        return Common.GUILD_MEMBER_TEMP.get(this.id);
    }

    public List<Channel> channels() {
        if (!Common.GUILD_CHANNEL_TEMP.containsKey(this.id)) {
            this.initTemp1();
        }
        return new ArrayList<Channel>(Common.GUILD_CHANNEL_TEMP.get(this.id).values());
    }

    public Map<String, Channel> channelMap() {
        if (!Common.GUILD_CHANNEL_TEMP.containsKey(this.id)) {
            this.initTemp1();
        }
        return Common.GUILD_CHANNEL_TEMP.get(this.id);
    }

    public Boolean getOwner() {
        return this.owner;
    }

    public String getJoinedAt() {
        return this.joinedAt;
    }

    public String getOwnerId() {
        return this.ownerId;
    }

    public String getName() {
        return this.name;
    }

    public String getIcon() {
        return this.icon;
    }

    public Integer getMaxMembers() {
        return this.maxMembers;
    }

    public String getDescription() {
        return this.description;
    }

    public String getId() {
        return this.id;
    }

    public Integer getMemberCount() {
        return this.memberCount;
    }

    public Guild setOwner(Boolean owner) {
        this.owner = owner;
        return this;
    }

    public Guild setJoinedAt(String joinedAt) {
        this.joinedAt = joinedAt;
        return this;
    }

    public Guild setOwnerId(String ownerId) {
        this.ownerId = ownerId;
        return this;
    }

    public Guild setName(String name) {
        this.name = name;
        return this;
    }

    public Guild setIcon(String icon) {
        this.icon = icon;
        return this;
    }

    public Guild setMaxMembers(Integer maxMembers) {
        this.maxMembers = maxMembers;
        return this;
    }

    public Guild setDescription(String description) {
        this.description = description;
        return this;
    }

    public Guild setId(String id) {
        this.id = id;
        return this;
    }

    public Guild setMemberCount(Integer memberCount) {
        this.memberCount = memberCount;
        return this;
    }

    public String toString() {
        return "Guild(owner=" + this.getOwner() + ", joinedAt=" + this.getJoinedAt() + ", ownerId=" + this.getOwnerId() + ", name=" + this.getName() + ", icon=" + this.getIcon() + ", maxMembers=" + this.getMaxMembers() + ", description=" + this.getDescription() + ", id=" + this.getId() + ", memberCount=" + this.getMemberCount() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Guild)) {
            return false;
        }
        Guild other = (Guild)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$owner = this.getOwner();
        Boolean other$owner = other.getOwner();
        if (this$owner == null ? other$owner != null : !((Object)this$owner).equals(other$owner)) {
            return false;
        }
        Integer this$maxMembers = this.getMaxMembers();
        Integer other$maxMembers = other.getMaxMembers();
        if (this$maxMembers == null ? other$maxMembers != null : !((Object)this$maxMembers).equals(other$maxMembers)) {
            return false;
        }
        Integer this$memberCount = this.getMemberCount();
        Integer other$memberCount = other.getMemberCount();
        if (this$memberCount == null ? other$memberCount != null : !((Object)this$memberCount).equals(other$memberCount)) {
            return false;
        }
        String this$joinedAt = this.getJoinedAt();
        String other$joinedAt = other.getJoinedAt();
        if (this$joinedAt == null ? other$joinedAt != null : !this$joinedAt.equals(other$joinedAt)) {
            return false;
        }
        String this$ownerId = this.getOwnerId();
        String other$ownerId = other.getOwnerId();
        if (this$ownerId == null ? other$ownerId != null : !this$ownerId.equals(other$ownerId)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$icon = this.getIcon();
        String other$icon = other.getIcon();
        if (this$icon == null ? other$icon != null : !this$icon.equals(other$icon)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        return !(this$id == null ? other$id != null : !this$id.equals(other$id));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Guild;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $owner = this.getOwner();
        result = result * 59 + ($owner == null ? 43 : ((Object)$owner).hashCode());
        Integer $maxMembers = this.getMaxMembers();
        result = result * 59 + ($maxMembers == null ? 43 : ((Object)$maxMembers).hashCode());
        Integer $memberCount = this.getMemberCount();
        result = result * 59 + ($memberCount == null ? 43 : ((Object)$memberCount).hashCode());
        String $joinedAt = this.getJoinedAt();
        result = result * 59 + ($joinedAt == null ? 43 : $joinedAt.hashCode());
        String $ownerId = this.getOwnerId();
        result = result * 59 + ($ownerId == null ? 43 : $ownerId.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $icon = this.getIcon();
        result = result * 59 + ($icon == null ? 43 : $icon.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        return result;
    }
}

