/*
 * Decompiled with CFR 0.152.
 */
package io.github.kloping.qqbot;

import io.github.kloping.MySpringTool.StarterObjectApplication;
import io.github.kloping.MySpringTool.interfaces.component.ContextManager;
import io.github.kloping.common.Public;
import io.github.kloping.qqbot.Resource;
import io.github.kloping.qqbot.Start0;
import io.github.kloping.qqbot.entities.Bot;
import io.github.kloping.qqbot.impl.ListenerHost;
import io.github.kloping.qqbot.network.WssWorker;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Future;

public class Starter
implements Runnable {
    public static final String NET_MAIN = "https://api.sgroup.qq.com/";
    public static final String APPID_ID = "appid";
    public static final String TOKEN_ID = "token";
    public static final String AUTH_ID = "appid-token";
    public static final String INTENTS_ID = "intents";
    public static final String SHARD_ID = "shard";
    public static final String PROPERTIES_ID = "properties";
    public static final String MAIN_FUTURE_ID = "main_future";
    public static final String RECONNECT_K_ID = "is_reconnect";
    public static final String CONFIG_ID = "config";
    public static final Integer CODE_4006 = 4006;
    public static final Integer CODE_4007 = 4007;
    public static final Integer CODE_4008 = 4008;
    public static final Integer CODE_4009 = 4009;
    public static final Integer CODE_4900 = 4900;
    public static final Integer CODE_4913 = 4913;
    private Config config = new Config();
    private WssWorker wssWorker;
    public final StarterObjectApplication APPLICATION = new StarterObjectApplication(Resource.class);
    private ContextManager contextManager;

    public Starter(String appid, String token) {
        this.getConfig().setAppid(appid);
        this.getConfig().setToken(token);
    }

    public Config getConfig() {
        return this.config;
    }

    @Override
    public void run() {
        this.APPLICATION.PRE_SCAN_RUNNABLE.add(() -> {
            this.APPLICATION.INSTANCE.getContextManager().append((Object)this.APPLICATION.logger);
            this.APPLICATION.INSTANCE.getContextManager().append((Object)this.APPLICATION.INSTANCE);
            this.APPLICATION.INSTANCE.getContextManager().append((Object)this.getConfig(), CONFIG_ID);
        });
        this.APPLICATION.logger.setLogLevel(1);
        this.APPLICATION.run0(Start0.class);
        this.after();
    }

    protected void after() {
        String appid = this.getConfig().getAppid();
        String token = this.getConfig().getToken();
        this.contextManager = this.APPLICATION.INSTANCE.getContextManager();
        this.contextManager.append((Object)this);
        this.contextManager.append((Object)appid, APPID_ID);
        this.contextManager.append((Object)token, TOKEN_ID);
        this.contextManager.append((Object)this.getConfig().getCode(), INTENTS_ID);
        this.contextManager.append((Object)new Integer[]{0, 1}, SHARD_ID);
        this.contextManager.append((Object)("Bot " + appid + "." + token), AUTH_ID);
        this.contextManager.append((Object)this.getConfig().getReconnect(), RECONNECT_K_ID);
        this.wssWorker = (WssWorker)this.contextManager.getContextEntity(WssWorker.class);
        this.wssWork();
    }

    protected void wssWork() {
        Future<?> future = Public.EXECUTOR_SERVICE.submit(this.wssWorker);
        this.APPLICATION.INSTANCE.getContextManager().append(future, MAIN_FUTURE_ID);
    }

    public void setReconnect(Boolean reconnect) {
        this.getConfig().setReconnect(reconnect);
    }

    public WssWorker getWssWorker() {
        return this.wssWorker;
    }

    public void registerListenerHost(ListenerHost listenerHost) {
        this.getConfig().getListenerHosts().add(listenerHost);
    }

    public Bot getBot() {
        return (Bot)this.contextManager.getContextEntity(Bot.class);
    }

    public static class Config {
        private String appid;
        private String token;
        private Integer code;
        private Boolean reconnect = true;
        private Set<ListenerHost> listenerHosts = new HashSet<ListenerHost>();

        public String getAppid() {
            return this.appid;
        }

        public String getToken() {
            return this.token;
        }

        public Integer getCode() {
            return this.code;
        }

        public Boolean getReconnect() {
            return this.reconnect;
        }

        public Set<ListenerHost> getListenerHosts() {
            return this.listenerHosts;
        }

        public void setAppid(String appid) {
            this.appid = appid;
        }

        public void setToken(String token) {
            this.token = token;
        }

        public void setCode(Integer code) {
            this.code = code;
        }

        public void setReconnect(Boolean reconnect) {
            this.reconnect = reconnect;
        }

        public void setListenerHosts(Set<ListenerHost> listenerHosts) {
            this.listenerHosts = listenerHosts;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Config)) {
                return false;
            }
            Config other = (Config)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Integer this$code = this.getCode();
            Integer other$code = other.getCode();
            if (this$code == null ? other$code != null : !((Object)this$code).equals(other$code)) {
                return false;
            }
            Boolean this$reconnect = this.getReconnect();
            Boolean other$reconnect = other.getReconnect();
            if (this$reconnect == null ? other$reconnect != null : !((Object)this$reconnect).equals(other$reconnect)) {
                return false;
            }
            String this$appid = this.getAppid();
            String other$appid = other.getAppid();
            if (this$appid == null ? other$appid != null : !this$appid.equals(other$appid)) {
                return false;
            }
            String this$token = this.getToken();
            String other$token = other.getToken();
            if (this$token == null ? other$token != null : !this$token.equals(other$token)) {
                return false;
            }
            Set<ListenerHost> this$listenerHosts = this.getListenerHosts();
            Set<ListenerHost> other$listenerHosts = other.getListenerHosts();
            return !(this$listenerHosts == null ? other$listenerHosts != null : !((Object)this$listenerHosts).equals(other$listenerHosts));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Config;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Integer $code = this.getCode();
            result = result * 59 + ($code == null ? 43 : ((Object)$code).hashCode());
            Boolean $reconnect = this.getReconnect();
            result = result * 59 + ($reconnect == null ? 43 : ((Object)$reconnect).hashCode());
            String $appid = this.getAppid();
            result = result * 59 + ($appid == null ? 43 : $appid.hashCode());
            String $token = this.getToken();
            result = result * 59 + ($token == null ? 43 : $token.hashCode());
            Set<ListenerHost> $listenerHosts = this.getListenerHosts();
            result = result * 59 + ($listenerHosts == null ? 43 : ((Object)$listenerHosts).hashCode());
            return result;
        }

        public String toString() {
            return "Starter.Config(appid=" + this.getAppid() + ", token=" + this.getToken() + ", code=" + this.getCode() + ", reconnect=" + this.getReconnect() + ", listenerHosts=" + this.getListenerHosts() + ")";
        }
    }
}

