/*
 * Decompiled with CFR 0.152.
 */
package io.github.kloping.qqbot.api.data.message;

import com.alibaba.fastjson.JSONObject;
import io.github.kloping.qqbot.Resource;
import io.github.kloping.qqbot.api.data.MessagePacket;
import io.github.kloping.qqbot.api.data.message.BaseMessageReceiveEvent;
import io.github.kloping.qqbot.api.interfaces.message.MessageDirectReceiveEvent;
import io.github.kloping.qqbot.api.qqpd.Guild;
import io.github.kloping.qqbot.api.qqpd.message.DirectMessage;
import io.github.kloping.qqbot.api.qqpd.message.Message;
import io.github.kloping.qqbot.api.qqpd.message.PreMessage;
import io.github.kloping.qqbot.api.qqpd.message.audited.MessageAudited;

public class BaseMessageDirectReceiveEvent
extends BaseMessageReceiveEvent
implements MessageDirectReceiveEvent {
    private String srcGuildId;
    private Guild srcGuild;
    private DirectMessage directMessage;

    public BaseMessageDirectReceiveEvent(Message message, JSONObject jo) {
        this.message = message;
        this.directMessage = DirectMessage.messageAsDirectMessage(message);
        this.metadata = jo;
        this.guild = Resource.starter.getBot().getGuild(this.getMessage().getGuildId());
        this.sender = this.getMessage().getMember();
        this.srcGuildId = this.getMessage().getSrcGuildId();
        this.content = this.getMessage().getContent() == null ? "" : this.getMessage().getContent();
        this.srcGuild = Resource.starter.getBot().getGuild(this.getSrcGuildId());
    }

    @Override
    public DirectMessage getDirectMessage() {
        return this.directMessage;
    }

    @Override
    public String getSrcGuildId() {
        return this.srcGuildId;
    }

    @Override
    public Guild getSrcGuild() {
        return this.srcGuild;
    }

    @Override
    public MessageAudited send(String text) {
        return this.sendDirect(text);
    }

    @Override
    public MessageAudited send(String text, Message message) {
        return this.sendDirect(text, message);
    }

    @Override
    public MessageAudited send(MessagePacket packet) {
        return this.sendDirect(packet);
    }

    @Override
    public MessageAudited send(PreMessage msg) {
        return this.sendDirect(msg);
    }

    @Override
    public MessageAudited sendDirect(String text) {
        return this.getDirectMessage().sendDirect(text);
    }

    @Override
    public MessageAudited sendDirect(String text, Message message) {
        return this.getDirectMessage().sendDirect(text, message);
    }

    @Override
    public MessageAudited sendDirect(MessagePacket packet) {
        return this.getDirectMessage().sendDirect(packet);
    }

    @Override
    public MessageAudited sendDirect(PreMessage msg) {
        return this.getDirectMessage().sendDirect(msg);
    }
}

