/*
 * Decompiled with CFR 0.152.
 */
package io.github.kloping.qqbot.api.data.message;

import com.alibaba.fastjson.JSONObject;
import io.github.kloping.qqbot.Resource;
import io.github.kloping.qqbot.api.data.MessagePacket;
import io.github.kloping.qqbot.api.interfaces.message.MessageEvent;
import io.github.kloping.qqbot.api.qqpd.Channel;
import io.github.kloping.qqbot.api.qqpd.Guild;
import io.github.kloping.qqbot.api.qqpd.Member;
import io.github.kloping.qqbot.api.qqpd.message.Message;
import io.github.kloping.qqbot.api.qqpd.message.PreMessage;
import io.github.kloping.qqbot.api.qqpd.message.audited.MessageAudited;

public class BaseMessageEvent
implements MessageEvent {
    protected Message message;
    protected JSONObject metadata;
    protected Guild guild;
    protected Member sender;
    protected Channel channel;

    public BaseMessageEvent() {
    }

    public BaseMessageEvent(Message message, JSONObject jo) {
        this.message = message;
        this.metadata = jo;
        this.guild = Resource.starter.getBot().getGuild(message.getGuildId());
        this.channel = this.getGuild().channelMap().get(message.getChannelId());
        this.sender = this.getGuild().memberMap().get(message.getAuthor().getId());
    }

    @Override
    public Message getMessage() {
        return this.message;
    }

    @Override
    public JSONObject getMetadata() {
        return this.metadata;
    }

    @Override
    public Guild getGuild() {
        return this.guild;
    }

    @Override
    public Member getSender() {
        return this.sender;
    }

    @Override
    public Channel getChannel() {
        return this.channel;
    }

    @Override
    public MessageAudited send(String text) {
        return this.getMessage().send(text);
    }

    @Override
    public MessageAudited send(String text, Message message) {
        return this.getMessage().send(text, message);
    }

    @Override
    public MessageAudited send(MessagePacket packet) {
        return this.getMessage().send(packet);
    }

    @Override
    public MessageAudited send(PreMessage msg) {
        return this.getMessage().send(msg);
    }
}

