/*
 * Decompiled with CFR 0.152.
 */
package io.github.kloping.qqbot.impl.message.v2;

import com.alibaba.fastjson.JSONObject;
import io.github.kloping.qqbot.api.SendAble;
import io.github.kloping.qqbot.api.v2.GroupMessageEvent;
import io.github.kloping.qqbot.entities.Bot;
import io.github.kloping.qqbot.entities.ex.At;
import io.github.kloping.qqbot.entities.ex.Image;
import io.github.kloping.qqbot.entities.ex.PlainText;
import io.github.kloping.qqbot.entities.ex.msg.MessageChain;
import io.github.kloping.qqbot.entities.qqpd.Channel;
import io.github.kloping.qqbot.entities.qqpd.data.Emoji;
import io.github.kloping.qqbot.entities.qqpd.message.RawMessage;
import io.github.kloping.qqbot.entities.qqpd.v2.Group;
import io.github.kloping.qqbot.entities.qqpd.v2.Member;
import io.github.kloping.qqbot.http.data.V2Result;
import io.github.kloping.qqbot.impl.message.v2.BaseMessageEvent;

public class BaseGroupMessageEvent
extends BaseMessageEvent
implements GroupMessageEvent {
    private Group subject;
    private Member sender;

    public BaseGroupMessageEvent(RawMessage message, JSONObject jo, Bot bot) {
        super(message, jo, bot);
        this.bot = bot;
        this.metadata = jo;
        this.rawMessage = message;
        this.subject = new Group(this.getMetadata());
        this.sender = new Member(this.getMetadata().getJSONObject("author"));
        this.msgId = this.getMetadata().getString("id");
    }

    @Override
    public String getGroupId() {
        return this.getSubject().getId();
    }

    @Override
    public V2Result sendMessage(String text) {
        return this.bot.groupV2Base.send(this.getSubject().getOpenid(), String.format("{\"msg_type\":0,\"content\":\"%s\",\"msg_id\":\"%s\"}", text, this.getMsgId()), Channel.SEND_MESSAGE_HEADERS);
    }

    @Override
    public V2Result sendMessage(SendAble msg) {
        V2Result result = this.sendE0(msg);
        return result;
    }

    private V2Result sendE0(SendAble msg) {
        if (msg instanceof PlainText) {
            return this.sendMessage(((PlainText)msg).getText());
        }
        if (msg instanceof Image) {
            return this.sendImage((Image)msg);
        }
        if (msg instanceof Emoji) {
            return this.sendMessage(msg.toString());
        }
        if (msg instanceof At) {
            return this.sendMessage(msg.toString());
        }
        if (msg instanceof MessageChain) {
            MessageChain chain = (MessageChain)msg;
            return this.sendChain(chain);
        }
        return null;
    }

    private V2Result sendChain(MessageChain chain) {
        V2Result result = new V2Result();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < chain.size(); ++i) {
            SendAble e = chain.get(i);
            if (e instanceof Image) {
                result = this.sendImage((Image)e);
                continue;
            }
            if (e instanceof MessageChain) {
                result = this.sendChain(chain);
                continue;
            }
            sb.append(e.toString());
        }
        if (sb.length() > 0) {
            result = this.sendMessage(sb.toString());
        }
        return result;
    }

    private V2Result sendImage(Image msg) {
        return this.bot.groupV2Base.sendFile(this.getSubject().getId(), String.format("{\"file_type\": 1,\"url\": \"%s\",\"srv_send_msg\": true}", msg.getUrl()), Channel.SEND_MESSAGE_HEADERS);
    }

    @Override
    public Group getGroup() {
        return this.getSubject();
    }

    @Override
    public Group getSubject() {
        return this.subject;
    }

    @Override
    public Member getSender() {
        return this.sender;
    }
}

