package io.github.kloping.qqbot.interfaces;

import org.java_websocket.client.WebSocketClient;

/**
 * @author github.kloping
 */
public interface OnCloseListener {
    /**
     * on wss close
     *
     * @param code wss closed <a href="https://bot.q.qq.com/wiki/develop/api/gateway/error/error.html#code">code</a>  <table><thead><tr><th style="text-align:left;">值</th> <th style="text-align:left;">含义</th> <th style="text-align:left;">是否可以重试 RESUME</th> <th style="text-align:left;">是否可以重试 IDENTIFY</th></tr></thead> <tbody><tr><td style="text-align:left;">4001</td> <td style="text-align:left;">无效的 opcode</td> <td style="text-align:left;">否</td> <td style="text-align:left;">否</td></tr> <tr><td style="text-align:left;">4002</td> <td style="text-align:left;">无效的 payload</td> <td style="text-align:left;">否</td> <td style="text-align:left;">否</td></tr> <tr><td style="text-align:left;">4007</td> <td style="text-align:left;">seq 错误</td> <td style="text-align:left;">否</td> <td style="text-align:left;"><strong>是</strong></td></tr> <tr><td style="text-align:left;">4006</td> <td style="text-align:left;">无效的 session id，无法继续 resume，请 identify</td> <td style="text-align:left;">否</td> <td style="text-align:left;"><strong>是</strong></td></tr> <tr><td style="text-align:left;">4008</td> <td style="text-align:left;">发送 payload 过快，请重新连接，并遵守连接后返回的频控信息</td> <td style="text-align:left;"><strong>是</strong></td> <td style="text-align:left;"><strong>是</strong></td></tr> <tr><td style="text-align:left;">4009</td> <td style="text-align:left;">连接过期，请重连并执行 resume 进行重新连接</td> <td style="text-align:left;"><strong>是</strong></td> <td style="text-align:left;"><strong>是</strong></td></tr> <tr><td style="text-align:left;">4010</td> <td style="text-align:left;">无效的 shard</td> <td style="text-align:left;">否</td> <td style="text-align:left;">否</td></tr> <tr><td style="text-align:left;">4011</td> <td style="text-align:left;">连接需要处理的 guild 过多，请进行合理的分片</td> <td style="text-align:left;">否</td> <td style="text-align:left;">否</td></tr> <tr><td style="text-align:left;">4012</td> <td style="text-align:left;">无效的 version</td> <td style="text-align:left;">否</td> <td style="text-align:left;">否</td></tr> <tr><td style="text-align:left;">4013</td> <td style="text-align:left;">无效的 intent</td> <td style="text-align:left;">否</td> <td style="text-align:left;">否</td></tr> <tr><td style="text-align:left;">4014</td> <td style="text-align:left;">intent 无权限</td> <td style="text-align:left;">否</td> <td style="text-align:left;">否</td></tr> <tr><td style="text-align:left;">4014</td> <td style="text-align:left;">intent 无权限</td> <td style="text-align:left;">否</td> <td style="text-align:left;">否</td></tr> <tr><td style="text-align:left;">4900~4913</td> <td style="text-align:left;">内部错误，请重连</td> <td style="text-align:left;">否</td> <td style="text-align:left;"><strong>是</strong></td></tr> <tr><td style="text-align:left;">4914</td> <td style="text-align:left;">机器人已下架,只允许连接沙箱环境,请断开连接,检验当前连接环境</td> <td style="text-align:left;">否</td> <td style="text-align:left;">否</td></tr> <tr><td style="text-align:left;">4915</td> <td style="text-align:left;">机器人已封禁,不允许连接,请断开连接,申请解封后再连接</td> <td style="text-align:left;">否</td> <td style="text-align:left;">否</td></tr></tbody></table>
     * @param wss
     */
    void onClose(int code, WebSocketClient wss);
}
