/*
 * Decompiled with CFR 0.152.
 */
package io.github.kloping.qqbot.impl.message.v2;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.annotation.JSONField;
import io.github.kloping.qqbot.api.message.MessageEvent;
import io.github.kloping.qqbot.api.v2.MessageV2Event;
import io.github.kloping.qqbot.entities.Bot;
import io.github.kloping.qqbot.entities.ex.enums.EnvType;
import io.github.kloping.qqbot.entities.ex.msg.MessageChain;
import io.github.kloping.qqbot.entities.qqpd.message.RawMessage;
import io.github.kloping.qqbot.entities.qqpd.v2.Contact;
import io.github.kloping.qqbot.entities.qqpd.v2.Group;
import io.github.kloping.qqbot.utils.BaseUtils;

public abstract class BaseMessageEvent
implements MessageEvent<Contact, Group>,
MessageV2Event {
    protected RawMessage rawMessage;
    protected Bot bot;
    protected JSONObject metadata;
    protected String msgId;
    protected MessageChain chain;
    @JSONField(serialize=false, deserialize=false)
    private Class<?>[] filters = null;

    public BaseMessageEvent(RawMessage message, JSONObject jo, Bot bot) {
        this.bot = bot;
        this.metadata = jo;
        this.rawMessage = message;
        this.rawMessage.setEnvType(EnvType.GROUP);
        this.msgId = this.getMetadata().getString("id");
    }

    @Override
    public abstract Contact getSender();

    public String toString() {
        return String.format("[type(%s) %s].%s:%s", EnvType.GROUP.name(), ((Group)this.getSubject()).getId(), this.getSender().getId(), this.getRawMessage().toString0());
    }

    @Override
    public MessageChain getMessage() {
        return this.chain == null ? (this.chain = BaseUtils.parseToMessageChain(this.getRawMessage(), this.filters)) : this.chain;
    }

    @Override
    public void setFilter(Class<?>[] filters) {
        this.filters = filters;
    }

    @Override
    public RawMessage getRawMessage() {
        return this.rawMessage;
    }

    @Override
    public Bot getBot() {
        return this.bot;
    }

    @Override
    public JSONObject getMetadata() {
        return this.metadata;
    }

    public String getMsgId() {
        return this.msgId;
    }

    public MessageChain getChain() {
        return this.chain;
    }

    public Class<?>[] getFilters() {
        return this.filters;
    }
}

