/*
 * Decompiled with CFR 0.152.
 */
package io.github.kloping.qqbot.entities.ex;

import io.github.kloping.qqbot.api.SendAble;
import io.github.kloping.qqbot.api.message.Builder;
import io.github.kloping.qqbot.entities.ex.At;
import io.github.kloping.qqbot.entities.ex.Image;
import io.github.kloping.qqbot.entities.ex.PlainText;
import io.github.kloping.qqbot.entities.ex.msg.MessageChain;

public class MessageAsyncBuilder
implements Builder<SendAble, SendAble> {
    private final MessageChain chain = new MessageChain();

    public MessageAsyncBuilder append(SendAble sendAble) {
        this.chain.append(sendAble);
        return this;
    }

    public MessageAsyncBuilder append(String text) {
        this.chain.append(new PlainText(text));
        return this;
    }

    @Override
    public SendAble build() {
        return this.chain;
    }

    public MessageAsyncBuilder at(String id) {
        return this.append(new At("member", id));
    }

    public MessageAsyncBuilder image(String url) {
        return this.append(new Image(url));
    }

    public MessageAsyncBuilder image(byte[] bytes) {
        return this.append(new Image(bytes));
    }

    public MessageAsyncBuilder text(String text) {
        return this.append(new PlainText(text));
    }

    public boolean isEmpty() {
        return this.chain.isEmpty();
    }
}

