/*
 * Decompiled with CFR 0.152.
 */
package io.github.kloping.qqbot;

import io.github.kloping.qqbot.entities.qqpd.Channel;
import io.github.kloping.qqbot.http.AuthV2Base;
import io.github.kloping.qqbot.http.data.Token;
import io.github.kloping.spt.annotations.AutoStand;
import io.github.kloping.spt.annotations.ComponentScan;
import io.github.kloping.spt.interfaces.component.ContextManager;
import java.util.HashMap;
import java.util.Map;

@ComponentScan(value="io.github.kloping.qqbot")
public class Start0 {
    public Map<String, String> headers = new HashMap<String, String>();
    @AutoStand
    ContextManager contextManager;
    private Token token;
    @AutoStand
    AuthV2Base authV2Base;

    public synchronized Map<String, String> getHeaders() {
        if (this.headers.isEmpty() || this.isExpired(this.token)) {
            this.updateToken();
        }
        return this.headers;
    }

    private boolean isExpired(Token token) {
        return token == null || token.isExpired();
    }

    public String getAccessToken() {
        if (this.isExpired(this.token)) {
            this.updateToken();
        }
        return this.token.getAccess_token();
    }

    public void updateToken() {
        this.headers.clear();
        String v2token = this.getV2Token();
        this.headers.put("Authorization", String.format("QQBot %s", v2token));
        this.headers.put("Accept-Encoding", "application/json");
        this.headers.put("X-Union-Appid", (String)this.contextManager.getContextEntity(String.class, "appid"));
    }

    private String getV2Token() {
        String appid = (String)this.contextManager.getContextEntity(String.class, "appid");
        String secret = (String)this.contextManager.getContextEntity(String.class, "secret");
        this.token = this.authV2Base.auth(String.format("{\"appId\": \"%s\",\"clientSecret\": \"%s\"}\n", appid, secret), Channel.SEND_MESSAGE_HEADERS).setT0(System.currentTimeMillis());
        return this.token.getAccess_token();
    }
}

