/*
 * Decompiled with CFR 0.152.
 */
package io.github.kloping.qqbot.entities.qqpd;

import com.alibaba.fastjson.annotation.JSONField;
import io.github.kloping.qqbot.api.AtAble;
import io.github.kloping.qqbot.api.OpAble;
import io.github.kloping.qqbot.api.SendAble;
import io.github.kloping.qqbot.entities.ex.At;
import io.github.kloping.qqbot.entities.ex.enums.EnvType;
import io.github.kloping.qqbot.entities.qqpd.Guild;
import io.github.kloping.qqbot.entities.qqpd.User;
import io.github.kloping.qqbot.entities.qqpd.message.RawMessage;
import io.github.kloping.qqbot.entities.qqpd.v2.Contact;
import io.github.kloping.qqbot.http.data.Result;
import java.util.Arrays;

public class Member
extends Contact
implements OpAble,
AtAble {
    private String nick;
    private String joinedAt;
    private String[] roles;
    private User user;
    private String opUserId;
    @JSONField(serialize=false, deserialize=false)
    private Guild guild;

    @Override
    public At at() {
        return new At("member", this.user.getId());
    }

    @Override
    public String getId() {
        return this.user.getId();
    }

    @Override
    public String getOpenid() {
        return this.getId();
    }

    @Override
    public Result send(String text) {
        return this.getGuild().create(this.user.getId()).send(text);
    }

    @Override
    public Result send(String text, RawMessage message) {
        return this.getGuild().create(this.user.getId()).send(text, message);
    }

    @Override
    public Result send(SendAble msg) {
        return this.getGuild().create(this.getId()).send(msg);
    }

    @Override
    public String getCid() {
        return this.getGuild().create(this.getId()).getCid();
    }

    @Override
    public EnvType getEnvType() {
        return EnvType.GUILD;
    }

    public String getNick() {
        return this.nick;
    }

    public String getJoinedAt() {
        return this.joinedAt;
    }

    public String[] getRoles() {
        return this.roles;
    }

    public User getUser() {
        return this.user;
    }

    @Override
    public String getOpUserId() {
        return this.opUserId;
    }

    public Member setNick(String nick) {
        this.nick = nick;
        return this;
    }

    public Member setJoinedAt(String joinedAt) {
        this.joinedAt = joinedAt;
        return this;
    }

    public Member setRoles(String[] roles) {
        this.roles = roles;
        return this;
    }

    public Member setUser(User user) {
        this.user = user;
        return this;
    }

    public Member setOpUserId(String opUserId) {
        this.opUserId = opUserId;
        return this;
    }

    @Override
    public String toString() {
        return "Member(nick=" + this.getNick() + ", joinedAt=" + this.getJoinedAt() + ", roles=" + Arrays.deepToString(this.getRoles()) + ", user=" + this.getUser() + ", opUserId=" + this.getOpUserId() + ", guild=" + this.getGuild() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Member)) {
            return false;
        }
        Member other = (Member)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$nick = this.getNick();
        String other$nick = other.getNick();
        if (this$nick == null ? other$nick != null : !this$nick.equals(other$nick)) {
            return false;
        }
        String this$joinedAt = this.getJoinedAt();
        String other$joinedAt = other.getJoinedAt();
        if (this$joinedAt == null ? other$joinedAt != null : !this$joinedAt.equals(other$joinedAt)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getRoles(), other.getRoles())) {
            return false;
        }
        User this$user = this.getUser();
        User other$user = other.getUser();
        if (this$user == null ? other$user != null : !((Object)this$user).equals(other$user)) {
            return false;
        }
        String this$opUserId = this.getOpUserId();
        String other$opUserId = other.getOpUserId();
        if (this$opUserId == null ? other$opUserId != null : !this$opUserId.equals(other$opUserId)) {
            return false;
        }
        Guild this$guild = this.getGuild();
        Guild other$guild = other.getGuild();
        return !(this$guild == null ? other$guild != null : !((Object)this$guild).equals(other$guild));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof Member;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $nick = this.getNick();
        result = result * 59 + ($nick == null ? 43 : $nick.hashCode());
        String $joinedAt = this.getJoinedAt();
        result = result * 59 + ($joinedAt == null ? 43 : $joinedAt.hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getRoles());
        User $user = this.getUser();
        result = result * 59 + ($user == null ? 43 : ((Object)$user).hashCode());
        String $opUserId = this.getOpUserId();
        result = result * 59 + ($opUserId == null ? 43 : $opUserId.hashCode());
        Guild $guild = this.getGuild();
        result = result * 59 + ($guild == null ? 43 : ((Object)$guild).hashCode());
        return result;
    }

    public Guild getGuild() {
        return this.guild;
    }

    public Member setGuild(Guild guild) {
        this.guild = guild;
        return this;
    }
}

