/*
 * Decompiled with CFR 0.152.
 */
package io.github.kloping.qqbot.impl.registers;

import com.alibaba.fastjson.JSONObject;
import io.github.kloping.map.MapUtils;
import io.github.kloping.qqbot.api.event.Event;
import io.github.kloping.qqbot.entities.Bot;
import io.github.kloping.qqbot.entities.qqpd.Common;
import io.github.kloping.qqbot.entities.qqpd.MemberWithGuildID;
import io.github.kloping.qqbot.entities.qqpd.message.RawMessage;
import io.github.kloping.qqbot.impl.BaseGuildEvent;
import io.github.kloping.qqbot.impl.BaseMemberRemoveEvent;
import io.github.kloping.qqbot.impl.BaseMemberUpdateEvent;
import io.github.kloping.qqbot.network.Events;
import io.github.kloping.spt.annotations.AutoStand;
import io.github.kloping.spt.annotations.AutoStandAfter;
import io.github.kloping.spt.annotations.Entity;

@Entity
public class MemberEventRegisters
implements Events.EventRegister {
    public static final String GUILD_MEMBER_ADD = "GUILD_MEMBER_ADD";
    public static final String GUILD_MEMBER_REMOVE = "GUILD_MEMBER_REMOVE";
    @AutoStand
    Bot bot;

    @AutoStandAfter
    private void r5(Events events) {
        events.register("GUILD_MEMBER_UPDATE", this).register(GUILD_MEMBER_ADD, this).register(GUILD_MEMBER_REMOVE, this);
    }

    @Override
    public Event handle(String t, JSONObject mateData, RawMessage message) {
        MemberWithGuildID member;
        BaseGuildEvent event;
        if (GUILD_MEMBER_REMOVE.equals(t)) {
            event = new BaseMemberRemoveEvent(mateData, this.bot);
            member = event.getMember();
        } else {
            event = new BaseMemberUpdateEvent(mateData, this.bot);
            member = event.getMember();
            event.getGuild().setMember(member);
        }
        if (GUILD_MEMBER_ADD.equals(t)) {
            MapUtils.append(Common.GUILD_MEMBER_TEMP, (Object)member.getGuildId(), (Object)member.getUser().getId(), (Object)member);
        } else if (GUILD_MEMBER_REMOVE.equals(t)) {
            Common.GUILD_MEMBER_TEMP.getOrDefault(event.getGuild().getId(), Common.EMPTY_MEMBER_MAP).remove(member.getUser().getId());
        }
        return event;
    }
}

