/*
 * Decompiled with CFR 0.152.
 */
package io.github.kloping.qqbot;

import io.github.kloping.qqbot.entities.qqpd.Channel;
import io.github.kloping.qqbot.http.AuthV2Base;
import io.github.kloping.qqbot.http.data.AccessToken;
import io.github.kloping.spt.annotations.AutoStand;
import io.github.kloping.spt.annotations.ComponentScan;
import io.github.kloping.spt.interfaces.component.ContextManager;
import java.util.HashMap;
import java.util.Map;

@ComponentScan(value="io.github.kloping.qqbot")
public class Start0 {
    public Map<String, String> headers = new HashMap<String, String>();
    @AutoStand
    ContextManager contextManager;
    private AccessToken accessToken;
    @AutoStand
    AuthV2Base authV2Base;

    public synchronized Map<String, String> getHeaders() {
        if (this.headers.isEmpty() || this.isExpired(this.accessToken)) {
            this.updateToken();
        }
        return this.headers;
    }

    private boolean isExpired(AccessToken accessToken) {
        return accessToken == null || accessToken.isExpired();
    }

    public String getAccessToken() {
        if (this.isExpired(this.accessToken)) {
            this.updateToken();
        }
        return this.accessToken.getAccess_token();
    }

    public void updateToken() {
        this.headers.clear();
        String v2token = this.getV2Token();
        this.headers.put("Authorization", String.format("QQBot %s", v2token));
        this.headers.put("Accept-Encoding", "application/json");
        this.headers.put("X-Union-Appid", (String)this.contextManager.getContextEntity(String.class, "appid"));
    }

    private String getV2Token() {
        String appid = (String)this.contextManager.getContextEntity(String.class, "appid");
        String secret = (String)this.contextManager.getContextEntity(String.class, "secret");
        this.accessToken = this.authV2Base.auth(new AppidAndSecret(appid, secret), Channel.SEND_MESSAGE_HEADERS).setT0(System.currentTimeMillis());
        return this.accessToken.getAccess_token();
    }

    public static class AppidAndSecret {
        public String appId;
        public String clientSecret;

        public AppidAndSecret(String appid, String secret) {
            this.appId = appid;
            this.clientSecret = secret;
        }

        public String getAppId() {
            return this.appId;
        }

        public String getClientSecret() {
            return this.clientSecret;
        }

        public void setAppId(String appId) {
            this.appId = appId;
        }

        public void setClientSecret(String clientSecret) {
            this.clientSecret = clientSecret;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AppidAndSecret)) {
                return false;
            }
            AppidAndSecret other = (AppidAndSecret)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$appId = this.getAppId();
            String other$appId = other.getAppId();
            if (this$appId == null ? other$appId != null : !this$appId.equals(other$appId)) {
                return false;
            }
            String this$clientSecret = this.getClientSecret();
            String other$clientSecret = other.getClientSecret();
            return !(this$clientSecret == null ? other$clientSecret != null : !this$clientSecret.equals(other$clientSecret));
        }

        protected boolean canEqual(Object other) {
            return other instanceof AppidAndSecret;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $appId = this.getAppId();
            result = result * 59 + ($appId == null ? 43 : $appId.hashCode());
            String $clientSecret = this.getClientSecret();
            result = result * 59 + ($clientSecret == null ? 43 : $clientSecret.hashCode());
            return result;
        }

        public String toString() {
            return "Start0.AppidAndSecret(appId=" + this.getAppId() + ", clientSecret=" + this.getClientSecret() + ")";
        }
    }
}

